/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ExamplePanelManager
extends AbstractRulePanelManager {
    private StyledText exampleField;
    private ModifyListener modifyListener;
    public static final String ID = "example";

    public ExamplePanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected void clearControls() {
        this.exampleField.setText("");
    }

    @Override
    public void showControls(boolean flag) {
        this.exampleField.setVisible(flag);
    }

    @Override
    protected void updateOverridenFields() {
        Rule rule = this.soleRule();
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            this.exampleField.setBackground((Color)(ruleReference.getOverriddenExamples() != null ? overridenColour : null));
        }
    }

    @Override
    public Control setupOn(Composite parent) {
        GridData gridData = new GridData(768);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        this.exampleField = this.newCodeField(panel);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.exampleField.setLayoutData((Object)gridData);
        this.exampleField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                Rule soleRule = ExamplePanelManager.this.soleRule();
                String cleanValue = ExamplePanelManager.this.exampleField.getText().trim();
                String existingValue = soleRule.getDescription();
                if (StringUtil.areSemanticEquals((String)existingValue, (String)cleanValue)) {
                    return;
                }
                soleRule.setDescription(cleanValue);
                ExamplePanelManager.this.valueChanged(null, cleanValue);
            }
        });
        return panel;
    }

    private void formatExampleOn(StringBuilder sb, String example) {
        String[] lines = example.split("\n");
        ArrayList<String> realLines = new ArrayList<String>(lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (StringUtil.isNotEmpty((String)line)) {
                realLines.add(line);
            }
            ++n2;
        }
        lines = realLines.toArray(new String[realLines.size()]);
        int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll((String[])lines);
        if (trimDepth > 0) {
            lines = StringUtil.trimStartOn((String[])lines, (int)trimDepth);
        }
        String[] stringArray2 = lines;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            String line = stringArray2[n];
            sb.append(line).append(PMD.EOL);
            ++n;
        }
    }

    private String examples(Rule rule) {
        List examples = rule.getExamples();
        if (examples.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatExampleOn(sb, (String)examples.get(0));
        int i = 1;
        while (i < examples.size()) {
            sb.append("----------");
            this.formatExampleOn(sb, (String)examples.get(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected void adapt() {
        Rule soleRule = this.soleRule();
        if (soleRule == null) {
            this.shutdown(this.exampleField);
        } else {
            this.show(this.exampleField, this.examples(soleRule));
            this.modifyListener = SyntaxManager.adapt(this.exampleField, soleRule.getLanguage().getTerseName(), this.modifyListener);
        }
    }
}

