/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.NumericPropertyDescriptor;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractRealNumberEditor;
import net.sourceforge.pmd.lang.rule.properties.DoubleProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class DoubleEditorFactory
extends AbstractRealNumberEditor {
    public static final DoubleEditorFactory instance = new DoubleEditorFactory();

    private DoubleEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new DoubleProperty(name, description, Double.valueOf(this.defaultIn(otherData).doubleValue()), Double.valueOf(this.minimumIn(otherData).doubleValue()), Double.valueOf(this.maximumIn(otherData).doubleValue()), 0.0f);
    }

    private static DoubleProperty doublePropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (DoubleProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (DoubleProperty)desc;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return (double)((Spinner)valueControl).getSelection() / scale;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final DoubleProperty dp = DoubleEditorFactory.doublePropertyFrom(desc);
        final Spinner spinner = this.newSpinnerFor(parent, source, (NumericPropertyDescriptor<?>)dp);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Double newValue = (double)spinner.getSelection() / scale;
                if (newValue.equals(DoubleEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)dp))) {
                    return;
                }
                source.setProperty((PropertyDescriptor)dp, (Object)newValue);
                listener.changed(source, (PropertyDescriptor<?>)dp, (Object)newValue);
                DoubleEditorFactory.this.adjustRendering(source, desc, (Control)spinner);
            }
        });
        return spinner;
    }
}

