/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.EditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.util.ColourManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractEditorFactory
implements EditorFactory {
    protected static ColourManager colourManager;

    protected AbstractEditorFactory() {
    }

    protected Label newLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    @Override
    public Control[] createOtherControlsOn(Composite parent, PropertyDescriptor<?> desc, PropertySource source, ValueChangeListener listener, SizeChangeListener sizeListener) {
        return new Control[]{this.newLabel(parent, "Default"), this.newEditorOn(parent, desc, source, listener, sizeListener)};
    }

    protected abstract Object valueFrom(Control var1);

    protected Object valueFor(PropertySource source, PropertyDescriptor<?> desc) {
        return source.hasDescriptor(desc) ? source.getProperty(desc) : desc.defaultValue();
    }

    @Override
    public Label addLabel(Composite parent, PropertyDescriptor<?> desc) {
        Label label = new Label(parent, 0);
        label.setText(desc.description());
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)data);
        return label;
    }

    protected static String asString(Object value) {
        return value == null ? "" : value.toString();
    }

    protected void adjustRendering(PropertySource source, PropertyDescriptor<?> desc, Control control) {
    }

    public static String asDelimitedString(Object values, char delimiter) {
        if (values == null) {
            return "";
        }
        if (values instanceof Object[]) {
            Object[] valueSet = (Object[])values;
            if (valueSet.length == 0) {
                return "";
            }
            if (valueSet.length == 1) {
                return AbstractEditorFactory.asString(valueSet[0]);
            }
            StringBuilder sb = new StringBuilder(AbstractEditorFactory.asString(valueSet[0]));
            int i = 1;
            while (i < valueSet.length) {
                sb.append(delimiter).append(AbstractEditorFactory.asString(valueSet[i]));
                ++i;
            }
            return sb.toString();
        }
        return AbstractEditorFactory.asString(values);
    }
}

