/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.properties.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.ui.IWorkingSet;

public class ProjectPropertiesImpl
implements IProjectProperties {
    private static final Logger log = Logger.getLogger(ProjectPropertiesImpl.class);
    private static final String PROJECT_RULESET_FILE = ".ruleset";
    private final IProjectPropertiesManager projectPropertiesManager;
    private final IProject project;
    private boolean needRebuild;
    private boolean pmdEnabled;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private RuleSet projectRuleSet;
    private long projectRuleFileLastModified = 0L;
    private IWorkingSet projectWorkingSet;
    private boolean includeDerivedFiles;
    private boolean violationsAsErrors = true;
    private boolean fullBuildEnabled = true;
    private Set<String> buildPathExcludePatterns = new HashSet<String>();
    private Set<String> buildPathIncludePatterns = new HashSet<String>();

    public ProjectPropertiesImpl(IProject project, IProjectPropertiesManager projectPropertiesManager) {
        this.project = project;
        this.projectPropertiesManager = projectPropertiesManager;
        this.projectRuleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        this.determineBuildPathIncludesExcludes();
    }

    private void determineBuildPathIncludesExcludes() {
        IClasspathEntry source = PMDPlugin.buildSourceClassPathEntryFor(this.project);
        if (source != null) {
            try {
                String pathString;
                IPath path;
                int n;
                int n2;
                IPath[] iPathArray;
                String basePath = new File(String.valueOf(this.project.getWorkspace().getRoot().getLocation().toOSString()) + File.separator + source.getPath().toOSString()).getCanonicalPath();
                if (!basePath.endsWith(File.separator)) {
                    basePath = String.valueOf(basePath) + File.separator;
                }
                if (source.getExclusionPatterns() != null) {
                    iPathArray = source.getExclusionPatterns();
                    n2 = iPathArray.length;
                    n = 0;
                    while (n < n2) {
                        path = iPathArray[n];
                        pathString = path.toOSString();
                        if (!pathString.endsWith(File.separator)) {
                            pathString = String.valueOf(pathString) + File.separator;
                        }
                        this.buildPathExcludePatterns.add(String.valueOf(basePath) + pathString + ".*");
                        ++n;
                    }
                }
                if (source.getInclusionPatterns() != null) {
                    iPathArray = source.getInclusionPatterns();
                    n2 = iPathArray.length;
                    n = 0;
                    while (n < n2) {
                        path = iPathArray[n];
                        pathString = path.toOSString();
                        if (!pathString.endsWith(File.separator)) {
                            pathString = String.valueOf(pathString) + File.separator;
                        }
                        this.buildPathIncludePatterns.add(String.valueOf(basePath) + pathString + ".*");
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"Couldn't determine build class path", (Throwable)e);
            }
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean isPmdEnabled() {
        return this.pmdEnabled;
    }

    @Override
    public void setPmdEnabled(boolean pmdEnabled) {
        log.debug((Object)("Enable PMD for project " + this.project.getName() + ": " + this.pmdEnabled));
        if (this.pmdEnabled != pmdEnabled) {
            this.pmdEnabled = pmdEnabled;
            this.needRebuild |= pmdEnabled;
        }
    }

    @Override
    public RuleSet getProjectRuleSet() throws PropertiesException {
        return this.cloneRuleSet();
    }

    @Override
    public void setProjectRuleSet(RuleSet projectRuleSet) throws PropertiesException {
        File f;
        log.debug((Object)("Set a rule set for project " + this.project.getName()));
        if (projectRuleSet == null) {
            throw new PropertiesException("Setting a project rule set to null");
        }
        this.needRebuild |= !this.projectRuleSet.getRules().equals(projectRuleSet.getRules());
        this.projectRuleSet = projectRuleSet;
        if (this.ruleSetStoredInProject && (f = this.getResolvedRuleSetFile()) != null) {
            this.projectRuleFileLastModified = f.lastModified();
        }
    }

    @Override
    public boolean isRuleSetStoredInProject() {
        return this.ruleSetStoredInProject;
    }

    @Override
    public void setRuleSetStoredInProject(boolean ruleSetStoredInProject) throws PropertiesException {
        log.debug((Object)("Set rule set stored in project for project " + this.project.getName() + ": " + ruleSetStoredInProject));
        this.needRebuild |= this.ruleSetStoredInProject ^ ruleSetStoredInProject;
        this.ruleSetStoredInProject = ruleSetStoredInProject;
        if (this.ruleSetStoredInProject) {
            if (!this.isRuleSetFileExist()) {
                throw new PropertiesException("The project ruleset file cannot be found for project " + this.project.getName());
            }
            File f = this.getResolvedRuleSetFile();
            if (f != null) {
                this.projectRuleFileLastModified = f.lastModified();
            }
        }
    }

    @Override
    public String getRuleSetFile() {
        return StringUtil.isEmpty((String)this.ruleSetFile) ? PROJECT_RULESET_FILE : this.ruleSetFile;
    }

    @Override
    public void setRuleSetFile(String ruleSetFile) throws PropertiesException {
        log.debug((Object)("Set rule set file for project " + this.project.getName() + ": " + ruleSetFile));
        this.needRebuild |= this.ruleSetFile == null || !this.ruleSetFile.equals(ruleSetFile);
        this.ruleSetFile = ruleSetFile;
        if (this.ruleSetStoredInProject) {
            if (!this.isRuleSetFileExist()) {
                throw new PropertiesException("The project ruleset file cannot be found for project " + this.project.getName());
            }
            File f = this.getResolvedRuleSetFile();
            if (f != null) {
                this.projectRuleFileLastModified = f.lastModified();
            }
        }
    }

    @Override
    public IWorkingSet getProjectWorkingSet() {
        return this.projectWorkingSet;
    }

    @Override
    public void setProjectWorkingSet(IWorkingSet projectWorkingSet) {
        log.debug((Object)("Set working set for project " + this.project.getName() + ": " + (projectWorkingSet == null ? "none" : projectWorkingSet.getName())));
        this.needRebuild |= projectWorkingSet == null ? this.projectWorkingSet != null : !projectWorkingSet.equals(this.projectWorkingSet);
        this.projectWorkingSet = projectWorkingSet;
    }

    @Override
    public boolean isNeedRebuild() {
        File f;
        log.debug((Object)("Query if project " + this.project.getName() + " need rebuild : " + (this.pmdEnabled && this.needRebuild)));
        log.debug((Object)("   PMD Enabled = " + this.pmdEnabled));
        log.debug((Object)("   Project need rebuild = " + this.needRebuild));
        if (this.ruleSetStoredInProject && (f = this.getResolvedRuleSetFile()) != null) {
            this.needRebuild |= f.lastModified() > this.projectRuleFileLastModified;
        }
        return this.pmdEnabled && this.needRebuild;
    }

    @Override
    public void setNeedRebuild(boolean needRebuild) {
        log.debug((Object)("Set if rebuild is needed for project " + this.project.getName() + ": " + needRebuild));
        this.needRebuild = needRebuild;
    }

    @Override
    public final boolean isRuleSetFileExist() {
        return this.getResolvedRuleSetFile().exists();
    }

    @Override
    public File getResolvedRuleSetFile() {
        IFile file = this.project.getFile(this.getRuleSetFile());
        File f = this.getExistingFileOrNull(file);
        if (f == null) {
            IWorkspaceRoot workspaceRoot = this.project.getWorkspace().getRoot();
            try {
                IFile workspaceFile = workspaceRoot.getFile((IPath)new Path(this.getRuleSetFile()));
                f = this.getExistingFileOrNull(workspaceFile);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (f == null) {
                f = new File(this.getRuleSetFile());
            }
        }
        return f;
    }

    private File getExistingFileOrNull(IFile file) {
        File f;
        boolean exists = file.exists() && file.isAccessible();
        File result = null;
        if (exists && (f = new File(file.getLocation().toOSString())).exists()) {
            result = f;
        }
        return result;
    }

    @Override
    public void createDefaultRuleSetFile() throws PropertiesException {
        log.info((Object)("Create a default rule set file for project " + this.project.getName()));
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            try {
                IRuleSetWriter writer = PMDPlugin.getDefault().getRuleSetWriter();
                baos = new ByteArrayOutputStream();
                writer.write(baos, this.projectRuleSet);
                IFile file = this.project.getFile(PROJECT_RULESET_FILE);
                if (file.exists() && file.isAccessible()) {
                    throw new PropertiesException("Project ruleset file already exists");
                }
                bais = new ByteArrayInputStream(baos.toByteArray());
                file.create((InputStream)bais, true, null);
            }
            catch (WriterException e) {
                throw new PropertiesException(e);
            }
            catch (CoreException e) {
                throw new PropertiesException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(baos);
            IOUtil.closeQuietly(bais);
            throw throwable;
        }
        IOUtil.closeQuietly(baos);
        IOUtil.closeQuietly(bais);
    }

    @Override
    public boolean isIncludeDerivedFiles() {
        return this.includeDerivedFiles;
    }

    @Override
    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        log.debug((Object)("Set if derived files should be included: " + includeDerivedFiles));
        this.needRebuild |= this.includeDerivedFiles ^ includeDerivedFiles;
        this.includeDerivedFiles = includeDerivedFiles;
    }

    @Override
    public void sync() throws PropertiesException {
        log.info((Object)("Commit properties for project " + this.project.getName()));
        this.projectPropertiesManager.storeProjectProperties(this);
    }

    private RuleSet cloneRuleSet() {
        RuleSet clonedRuleSet = new RuleSet();
        clonedRuleSet.setName(this.projectRuleSet.getName());
        clonedRuleSet.setDescription(this.projectRuleSet.getDescription());
        for (Rule rule : this.projectRuleSet.getRules()) {
            clonedRuleSet.addRule(rule);
        }
        clonedRuleSet.addExcludePatterns((Collection)this.projectRuleSet.getExcludePatterns());
        clonedRuleSet.addIncludePatterns((Collection)this.projectRuleSet.getIncludePatterns());
        return clonedRuleSet;
    }

    @Override
    public boolean violationsAsErrors() throws PropertiesException {
        return this.violationsAsErrors;
    }

    @Override
    public void setViolationsAsErrors(boolean violationsAsErrors) throws PropertiesException {
        log.debug((Object)("Set to handle violations as errors: " + violationsAsErrors));
        this.needRebuild |= this.violationsAsErrors ^ violationsAsErrors;
        this.violationsAsErrors = violationsAsErrors;
    }

    @Override
    public boolean isFullBuildEnabled() throws PropertiesException {
        return this.fullBuildEnabled;
    }

    @Override
    public void setFullBuildEnabled(boolean fullBuildEnabled) throws PropertiesException {
        log.debug((Object)("Set if run at full build for project " + this.project.getName() + ": " + fullBuildEnabled));
        if (this.fullBuildEnabled != fullBuildEnabled) {
            this.fullBuildEnabled = fullBuildEnabled;
            if (this.fullBuildEnabled) {
                this.needRebuild = true;
            }
        }
    }

    public String toString() {
        String projectName = "n/a";
        String projectRuleSetName = "n/a";
        String projectWorkingSetName = "n/a";
        if (this.project != null) {
            projectName = this.project.getName();
        }
        if (this.projectRuleSet != null) {
            projectRuleSetName = this.projectRuleSet.getName();
        }
        if (this.projectWorkingSet != null) {
            projectWorkingSetName = this.projectWorkingSet.getName();
        }
        return "fullBuildEnabled:" + this.fullBuildEnabled + " includeDerivedFiles:" + this.includeDerivedFiles + " pmdEnabled:" + this.pmdEnabled + " project:" + projectName + " projectRuleSet:" + projectRuleSetName + " projectWorkingSet:" + projectWorkingSetName + " ruleSetFile:" + this.ruleSetFile + " ruleSetStoredInProject:" + this.ruleSetStoredInProject + " violationsAsErrors: " + this.violationsAsErrors;
    }

    @Override
    public Set<String> getBuildPathExcludePatterns() {
        return this.buildPathExcludePatterns;
    }

    @Override
    public Set<String> getBuildPathIncludePatterns() {
        return this.buildPathIncludePatterns;
    }
}

