/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.IProfileHistory;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springframework.ide.eclipse.boot.util.JavaProjectUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class ProfileLaunchTabModel
extends LaunchTabSelectionModel<String> {
    private static final Pattern FILE_NAME_PAT = Pattern.compile("^application-(.*)\\.properties$");
    private static final int FILE_NAME_PAT_GROUP = 1;
    private static final String[] NO_PROFILES = new String[0];
    private final LiveExpression<String[]> profiles;

    public static ProfileLaunchTabModel create(LiveExpression<IProject> project, IProfileHistory profileHistory) {
        LiveVariable profile = new LiveVariable((Object)"");
        return new ProfileLaunchTabModel(project, (LiveVariable<String>)profile, (LiveExpression<ValidationResult>)Validator.OK, profileHistory);
    }

    protected ProfileLaunchTabModel(LiveExpression<IProject> project, LiveVariable<String> selection, LiveExpression<ValidationResult> validator, IProfileHistory profileHistory) {
        super(selection, validator);
        this.profiles = new ProfileOptions(project, profileHistory);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        String profile = BootLaunchConfigurationDelegate.getProfile(conf);
        this.selection.setValue((Object)profile);
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        String profile = (String)this.selection.getValue();
        BootLaunchConfigurationDelegate.setProfile(conf, profile);
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setProfile(conf, "");
    }

    public LiveExpression<String[]> profileOptions() {
        return this.profiles;
    }

    private class ProfileOptions
    extends LiveExpression<String[]> {
        private final IProfileHistory profileHistory;
        private final LiveExpression<IProject> project;

        public ProfileOptions(LiveExpression<IProject> project, IProfileHistory profileHistory) {
            super((Object)NO_PROFILES);
            this.profileHistory = profileHistory;
            this.project = project;
            this.dependsOn(project);
        }

        protected String[] compute() {
            LinkedHashSet<String> profiles = new LinkedHashSet<String>();
            this.discoverValidProfiles(profiles);
            this.addHistoricProfiles(profiles);
            return profiles.toArray(new String[profiles.size()]);
        }

        private void addHistoricProfiles(LinkedHashSet<String> profiles) {
            IProject proj = (IProject)this.project.getValue();
            if (proj != null) {
                String[] stringArray = this.profileHistory.getHistory(proj);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String profile = stringArray[n2];
                    profiles.add(profile);
                    ++n2;
                }
            }
        }

        private void discoverValidProfiles(LinkedHashSet<String> profiles) {
            try {
                IContainer[] iContainerArray = JavaProjectUtil.getSourceFolders((IProject)((IProject)this.project.getValue()));
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer srcFolder = iContainerArray[n2];
                    IResource[] iResourceArray = srcFolder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource rsrc = iResourceArray[n4];
                        if (rsrc.getType() == 1) {
                            String name = rsrc.getName();
                            Matcher matcher = FILE_NAME_PAT.matcher(name);
                            if (matcher.matches()) {
                                profiles.add(matcher.group(1));
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
    }
}

