/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.launch.livebean.JmxBeanSupport;
import org.springframework.ide.eclipse.boot.launch.process.BootProcessFactory;
import org.springframework.ide.eclipse.boot.launch.profiles.ProfileHistory;
import org.springframework.ide.eclipse.boot.util.StringUtil;
import org.springsource.ide.eclipse.commons.core.util.OsUtils;

public class BootLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    private static final String M2E_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    private static final String M2E_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String LAUNCH_CONFIG_TYPE_ID = "org.springframework.ide.eclipse.boot.launch";
    private static final String JAVA_LAUNCH_CONFIG_TYPE_ID = IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    private static final String PROPS_PREFIX = "spring.boot.prop.";
    private static final char OID_SEPERATOR = ':';
    public static final String ENABLE_DEBUG_OUTPUT = "spring.boot.debug.enable";
    public static final boolean DEFAULT_ENABLE_DEBUG_OUTPUT = false;
    public static final String ENABLE_LIVE_BEAN_SUPPORT = "spring.boot.livebean.enable";
    public static final boolean DEFAULT_ENABLE_LIVE_BEAN_SUPPORT = true;
    private static final String JMX_PORT = "spring.boot.livebean.port";
    private static final String PROFILE = "spring.boot.profile";
    public static final String DEFAULT_PROFILE = "";
    private static final String ENABLE_CHEAP_ENTROPY_VM_ARGS = "-Djava.security.egd=file:/dev/./urandom ";
    public static final String ENABLE_LIFE_CYCLE = "spring.boot.lifecycle.enable";
    public static final boolean DEFAULT_ENABLE_LIFE_CYCLE = true;
    private ProfileHistory profileHistory = new ProfileHistory();

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.profileHistory.updateHistory(BootLaunchConfigurationDelegate.getProject(conf), BootLaunchConfigurationDelegate.getProfile(conf));
        super.launch(conf, mode, launch, monitor);
    }

    public String[] getClasspath(ILaunchConfiguration conf) throws CoreException {
        try {
            ILaunchConfigurationWorkingCopy wc = BootLaunchConfigurationDelegate.copyAs(conf, JAVA_LAUNCH_CONFIG_TYPE_ID);
            BootLaunchConfigurationDelegate.enableMavenClasspathProvider(wc);
            return super.getClasspath((ILaunchConfiguration)wc);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return super.getClasspath(conf);
        }
    }

    private static ILaunchConfigurationWorkingCopy copyAs(ILaunchConfiguration conf, String newType) throws CoreException {
        ILaunchManager launchManager = BootLaunchConfigurationDelegate.getLaunchMan();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(newType);
        ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, launchManager.generateLaunchConfigurationName(conf.getName()));
        wc.setAttributes(conf.getAttributes());
        return wc;
    }

    public String getProgramArguments(ILaunchConfiguration conf) throws CoreException {
        List<PropVal> props = BootLaunchConfigurationDelegate.getProperties(conf);
        String profile = BootLaunchConfigurationDelegate.getProfile(conf);
        boolean debugOutput = BootLaunchConfigurationDelegate.getEnableDebugOutput(conf);
        if (!(props != null && !props.isEmpty() || debugOutput || StringUtil.hasText((String)profile))) {
            return super.getProgramArguments(conf);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (debugOutput) {
            args.add("--debug");
        }
        if (StringUtil.hasText((String)profile)) {
            args.add(this.propertyAssignmentArgument("spring.profiles.active", profile));
        }
        this.addPropertiesArguments(args, props);
        args.addAll(Arrays.asList(DebugPlugin.parseArguments((String)super.getProgramArguments(conf))));
        return DebugPlugin.renderArguments((String[])args.toArray(new String[args.size()]), null);
    }

    public String getVMArguments(ILaunchConfiguration conf) throws CoreException {
        try {
            String vmArgs = super.getVMArguments(conf);
            EnumSet<JmxBeanSupport.Feature> enabled = BootLaunchConfigurationDelegate.getEnabledJmxFeatures(conf);
            if (!enabled.isEmpty()) {
                int port = 0;
                try {
                    port = Integer.parseInt(BootLaunchConfigurationDelegate.getJMXPort(conf));
                }
                catch (Exception exception) {}
                if (port == 0) {
                    port = JmxBeanSupport.randomPort();
                }
                String enableLiveBeanArgs = JmxBeanSupport.jmxBeanVmArgs(port, enabled);
                vmArgs = String.valueOf(enableLiveBeanArgs) + vmArgs;
            }
            return vmArgs;
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return super.getVMArguments(conf);
        }
    }

    public static EnumSet<JmxBeanSupport.Feature> getEnabledJmxFeatures(ILaunchConfiguration conf) {
        EnumSet<JmxBeanSupport.Feature> enabled = EnumSet.noneOf(JmxBeanSupport.Feature.class);
        if (BootLaunchConfigurationDelegate.getEnableLiveBeanSupport(conf)) {
            enabled.add(JmxBeanSupport.Feature.LIVE_BEAN_GRAPH);
        }
        if (BootLaunchConfigurationDelegate.getEnableLifeCycle(conf)) {
            enabled.add(JmxBeanSupport.Feature.LIFE_CYCLE);
        }
        return enabled;
    }

    public static boolean getEnableLifeCycle(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_LIFE_CYCLE, true);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return true;
        }
    }

    public static void setEnableLifeCycle(ILaunchConfigurationWorkingCopy wc, boolean enable) {
        wc.setAttribute(ENABLE_LIFE_CYCLE, enable);
    }

    public static boolean canUseLifeCycle(ILaunchConfiguration conf) {
        return BootLaunchConfigurationDelegate.getEnableLifeCycle(conf) && BootLaunchConfigurationDelegate.supportsLifeCycleManagement(conf);
    }

    public static boolean supportsLifeCycleManagement(ILaunchConfiguration conf) {
        IProject p = BootLaunchConfigurationDelegate.getProject(conf);
        if (p != null) {
            return BootPropertyTester.supportsLifeCycleManagement((IProject)p);
        }
        return false;
    }

    private void addPropertiesArguments(ArrayList<String> args, List<PropVal> props) {
        for (PropVal p : props) {
            if (!p.isChecked || p.name.isEmpty() || p.value.isEmpty()) continue;
            args.add(this.propertyAssignmentArgument(p.name, p.value));
        }
    }

    private String propertyAssignmentArgument(String name, String value) {
        if (name.contains("=")) {
            throw new IllegalArgumentException("property name shouldn't contain '=':" + name);
        }
        return "--" + name + "=" + value;
    }

    public static List<ILaunchConfiguration> getLaunchConfigs(IProject p) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchManager lm = BootLaunchConfigurationDelegate.getLaunchMan();
            ILaunchConfigurationType type = lm.getLaunchConfigurationType(LAUNCH_CONFIG_TYPE_ID);
            if (type != null && (configs = lm.getLaunchConfigurations(type)) != null && configs.length > 0) {
                ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration conf = iLaunchConfigurationArray[n2];
                    if (p.equals((Object)BootLaunchConfigurationDelegate.getProject(conf))) {
                        result.add(conf);
                    }
                    ++n2;
                }
                return result;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy wc, IProject project, String mainType) {
        BootLaunchConfigurationDelegate.setProcessFactory(wc, BootProcessFactory.class);
        BootLaunchConfigurationDelegate.setProject(wc, project);
        if (mainType != null) {
            BootLaunchConfigurationDelegate.setMainType(wc, mainType);
        }
        BootLaunchConfigurationDelegate.setEnableLiveBeanSupport(wc, true);
        BootLaunchConfigurationDelegate.setEnableLifeCycle(wc, true);
        BootLaunchConfigurationDelegate.setJMXPort(wc, DEFAULT_PROFILE + JmxBeanSupport.randomPort());
        if (!OsUtils.isWindows()) {
            BootLaunchConfigurationDelegate.setVMArgs(wc, ENABLE_CHEAP_ENTROPY_VM_ARGS);
        }
    }

    private static void setVMArgs(ILaunchConfigurationWorkingCopy wc, String vmArgs) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
    }

    public static void setProcessFactory(ILaunchConfigurationWorkingCopy wc, Class<BootProcessFactory> klass) {
        wc.setAttribute("process_factory_id", klass.getName());
    }

    public static void setMainType(ILaunchConfigurationWorkingCopy config, String typeName) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, typeName);
    }

    public static List<PropVal> getProperties(ILaunchConfiguration conf) {
        ArrayList<PropVal> props = new ArrayList<PropVal>();
        try {
            for (Map.Entry _e : conf.getAttributes().entrySet()) {
                try {
                    Map.Entry e = _e;
                    String prefixed = (String)e.getKey();
                    if (!prefixed.startsWith(PROPS_PREFIX)) continue;
                    String name = prefixed.substring(PROPS_PREFIX.length());
                    int dotPos = name.lastIndexOf(58);
                    if (dotPos >= 0) {
                        name = name.substring(0, dotPos);
                    }
                    String valueEnablement = (String)e.getValue();
                    String value = valueEnablement.substring(1);
                    boolean enabled = valueEnablement.charAt(0) == '1';
                    props.add(new PropVal(name, value, enabled));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return props;
    }

    public static void setProperties(ILaunchConfigurationWorkingCopy conf, List<PropVal> props) {
        if (props == null) {
            props = Collections.emptyList();
        }
        BootLaunchConfigurationDelegate.clearProperties(conf);
        int oid = 0;
        for (PropVal p : props) {
            if (!StringUtil.hasText((String)p.name)) continue;
            String prefixed = PROPS_PREFIX + p.name + ':' + oid++;
            String valueEnabled = String.valueOf(p.isChecked ? (char)'1' : '0') + p.value;
            conf.setAttribute(prefixed, valueEnabled);
        }
    }

    public static IProject getProject(ILaunchConfiguration conf) {
        try {
            String pname = BootLaunchConfigurationDelegate.getProjectName(conf);
            if (StringUtil.hasText((String)pname)) {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
                return p;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration conf) throws CoreException {
        return conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, DEFAULT_PROFILE);
    }

    public static void clearProperties(ILaunchConfigurationWorkingCopy conf) {
        try {
            for (Object _prefixedProp : conf.getAttributes().keySet()) {
                String prefixedProp = (String)_prefixedProp;
                if (!prefixedProp.startsWith(PROPS_PREFIX)) continue;
                conf.removeAttribute(prefixedProp);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    public static boolean getEnableDebugOutput(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_DEBUG_OUTPUT, false);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return false;
        }
    }

    public static void setEnableDebugOutput(ILaunchConfigurationWorkingCopy conf, boolean enable) {
        conf.setAttribute(ENABLE_DEBUG_OUTPUT, enable);
    }

    public static void setProject(ILaunchConfigurationWorkingCopy conf, IProject p) {
        if (p == null) {
            conf.removeAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME);
        } else {
            conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, p.getName());
        }
    }

    public static boolean getEnableLiveBeanSupport(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_LIVE_BEAN_SUPPORT, true);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return true;
        }
    }

    public static String getJMXPort(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(JMX_PORT, DEFAULT_PROFILE);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return DEFAULT_PROFILE;
        }
    }

    public static void setEnableLiveBeanSupport(ILaunchConfigurationWorkingCopy conf, boolean value) {
        conf.setAttribute(ENABLE_LIVE_BEAN_SUPPORT, value);
    }

    public static void setJMXPort(ILaunchConfigurationWorkingCopy conf, String portAsStr) {
        conf.setAttribute(JMX_PORT, portAsStr);
    }

    public static String getProfile(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(PROFILE, DEFAULT_PROFILE);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return DEFAULT_PROFILE;
        }
    }

    public static void setProfile(ILaunchConfigurationWorkingCopy conf, String profile) {
        conf.setAttribute(PROFILE, profile);
    }

    private static void enableMavenClasspathProvider(ILaunchConfigurationWorkingCopy conf) {
        try {
            IProject p;
            if (conf.getType().getIdentifier().equals(JAVA_LAUNCH_CONFIG_TYPE_ID) && (p = BootLaunchConfigurationDelegate.getProject((ILaunchConfiguration)conf)) != null && p.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                if (!conf.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER)) {
                    conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, M2E_CLASSPATH_PROVIDER);
                }
                if (!conf.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER)) {
                    conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, M2E_SOURCEPATH_PROVIDER);
                }
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    public static ILaunchConfigurationWorkingCopy createWorkingCopy(String nameHint) throws CoreException {
        String name = BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(nameHint);
        return BootLaunchConfigurationDelegate.getConfType().newInstance(null, name);
    }

    private static ILaunchManager getLaunchMan() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static ILaunchConfigurationType getConfType() {
        return BootLaunchConfigurationDelegate.getLaunchMan().getLaunchConfigurationType(LAUNCH_CONFIG_TYPE_ID);
    }

    public static ILaunchConfiguration createConf(IType type) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = BootLaunchConfigurationDelegate.getConfType();
        IProject project = type.getJavaProject().getProject();
        String projectName = type.getJavaProject().getElementName();
        String shortTypeName = type.getTypeQualifiedName('.');
        String typeName = type.getFullyQualifiedName();
        wc = configType.newInstance(null, BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(String.valueOf(projectName) + " - " + shortTypeName));
        BootLaunchConfigurationDelegate.setDefaults(wc, project, typeName);
        wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
        return wc.doSave();
    }

    public static ILaunchConfiguration createConf(IJavaProject project) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = BootLaunchConfigurationDelegate.getConfType();
        String projectName = project.getElementName();
        wc = configType.newInstance(null, BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(projectName));
        BootLaunchConfigurationDelegate.setDefaults(wc, project.getProject(), null);
        wc.setMappedResources(new IResource[]{project.getUnderlyingResource()});
        return wc.doSave();
    }

    public static int getJMXPortAsInt(ILaunchConfiguration conf) {
        String jmxPortStr = BootLaunchConfigurationDelegate.getJMXPort(conf);
        if (jmxPortStr != null) {
            try {
                return Integer.parseInt(jmxPortStr);
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static class PropVal {
        public String name;
        public String value;
        public boolean isChecked;

        public PropVal(String name, String value, boolean isChecked) {
            Assert.isNotNull((Object)name);
            Assert.isNotNull((Object)value);
            this.name = name;
            this.value = value;
            this.isChecked = isChecked;
        }

        public String toString() {
            return String.valueOf(this.isChecked ? "[X] " : "[ ] ") + this.name + "=" + this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.isChecked ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropVal other = (PropVal)obj;
            if (this.isChecked != other.isChecked) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

