/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.springframework.ide.eclipse.core.SpringCorePreferences;

public class MavenPreferencePage
extends PropertyPage {
    private IProject project;
    private Button automaticallyUpdateDependenciesButton;
    private boolean modified = false;
    private boolean automaticallyUpdateDependencies;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite parentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        parentComposite.setLayout((Layout)layout);
        parentComposite.setLayoutData((Object)new GridData(768));
        parentComposite.setFont(font);
        this.initialize();
        this.automaticallyUpdateDependenciesButton = new Button(parentComposite, 32);
        this.automaticallyUpdateDependenciesButton.setText("Automatically update dependencies from Maven pom.xml");
        this.automaticallyUpdateDependenciesButton.setSelection(this.automaticallyUpdateDependencies);
        this.automaticallyUpdateDependenciesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenPreferencePage.this.modified = true;
            }
        });
        return parentComposite;
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.noDefaultAndApplyButton();
        this.setDescription("Automatically update project configuration and dependency based on Maven pom.xml");
        this.automaticallyUpdateDependencies = this.project != null ? SpringCorePreferences.getProjectPreferences((IProject)this.project, (String)"org.springframework.ide.eclipse.maven").getBoolean("maven.automatically.update", false) : false;
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        SpringCorePreferences.getProjectPreferences((IProject)this.project, (String)"org.springframework.ide.eclipse.maven").putBoolean("maven.automatically.update", this.automaticallyUpdateDependenciesButton.getSelection());
        return true;
    }
}

