/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util.signature;

import java.util.List;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;

public class TypeSignature {
    private TypeSignature() {
    }

    public static String getSignature(Type type) {
        return TypeSignature.dispatch(type);
    }

    private static String getPrimitiveSignature(PrimitiveType pt) {
        String type = pt.toString();
        if ("byte".equals(type)) {
            return "B";
        }
        if ("short".equals(type)) {
            return "S";
        }
        if ("char".equals(type)) {
            return "C";
        }
        if ("int".equals(type)) {
            return "I";
        }
        if ("long".equals(type)) {
            return "J";
        }
        if ("float".equals(type)) {
            return "F";
        }
        if ("double".equals(type)) {
            return "D";
        }
        if ("boolean".equals(type)) {
            return "Z";
        }
        if ("void".equals(type)) {
            return "V";
        }
        return "";
    }

    private static String getArraySignature(ArrayType type) {
        int dimensions = type.getDimensions();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < dimensions) {
            buf.append("[");
            ++i;
        }
        buf.append(TypeSignature.dispatch(type.getComponentType()));
        return buf.toString();
    }

    private static String getTypeSignature(Type type) {
        return "Q" + type.toString() + ";";
    }

    private static String getWildcardSignature(WildcardType wtype) {
        if (wtype.isUpperBound()) {
            return "+" + TypeSignature.dispatch(wtype.getBound());
        }
        return "-" + TypeSignature.dispatch(wtype.getBound());
    }

    private static String getParameterizedSignature(ParameterizedType ptype) {
        StringBuffer buf = new StringBuffer();
        String sig = TypeSignature.dispatch(ptype.getType());
        if (sig.length() > 0) {
            buf.append(sig.substring(0, sig.length() - 1));
        } else {
            buf.append(sig);
        }
        buf.append("<");
        List types = ptype.typeArguments();
        int i = 0;
        while (i < types.size()) {
            buf.append(TypeSignature.dispatch((Type)types.get(i)));
            ++i;
        }
        buf.append(">;");
        return buf.toString();
    }

    private static String dispatch(Type type) {
        if (type == null) {
            return "";
        }
        if (type.isArrayType()) {
            return TypeSignature.getArraySignature((ArrayType)type);
        }
        if (type.isPrimitiveType()) {
            return TypeSignature.getPrimitiveSignature((PrimitiveType)type);
        }
        if (type.isSimpleType()) {
            return TypeSignature.getTypeSignature((Type)((SimpleType)type));
        }
        if (type.isQualifiedType()) {
            return TypeSignature.getTypeSignature((Type)((QualifiedType)type));
        }
        if (type.isParameterizedType()) {
            return TypeSignature.getParameterizedSignature((ParameterizedType)type);
        }
        if (type.isWildcardType()) {
            return TypeSignature.getWildcardSignature((WildcardType)type);
        }
        return "";
    }
}

