/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.TestSearchEngine;

public class TestSelectionDialog
extends TwoPaneElementSelector {
    private IJavaProject m_project;
    private Object[] m_input;
    private Filters.ITypeFilter m_filter;
    private TestNGLaunchConfigurationConstants.LaunchType m_testngType;

    public static TestSelectionDialog createSuiteSelectionDialog(Shell shell, IJavaProject jproject, Object[] resources) {
        TestSelectionDialog result = new TestSelectionDialog(shell, TestNGLaunchConfigurationConstants.LaunchType.SUITE, jproject, (ILabelProvider)new FileLabelProvider(1), (ILabelProvider)new FileLabelProvider(2), resources, null);
        result.setMessage(ResourceUtil.getString("TestNGMainTab.testdialog.selectSuite"));
        return result;
    }

    public static TestSelectionDialog createTestTypeSelectionDialog(Shell shell, IJavaProject jproject, Object[] types, Filters.ITypeFilter filter) {
        return TestSelectionDialog.createJavaElementDialog(shell, jproject, types, TestNGLaunchConfigurationConstants.LaunchType.CLASS, "TestNGMainTab.testdialog.selectTestClass", filter);
    }

    public static TestSelectionDialog createPackageSelectionDialog(Shell shell, IJavaProject jproject, Object[] types) {
        return TestSelectionDialog.createJavaElementDialog(shell, jproject, types, TestNGLaunchConfigurationConstants.LaunchType.PACKAGE, "TestNGMainTab.testdialog.selectPackage", null);
    }

    public static TestSelectionDialog createMethodSelectionDialog(Shell shell, IJavaProject jproject, Object[] types) {
        return TestSelectionDialog.createJavaElementDialog(shell, jproject, types, TestNGLaunchConfigurationConstants.LaunchType.METHOD, "TestNGMainTab.testdialog.selectMethod", null);
    }

    private static TestSelectionDialog createJavaElementDialog(Shell shell, IJavaProject jproject, Object[] types, TestNGLaunchConfigurationConstants.LaunchType testngType, String title, Filters.ITypeFilter filter) {
        TestSelectionDialog result = new TestSelectionDialog(shell, testngType, jproject, (ILabelProvider)new JavaElementLabelProvider(16), (ILabelProvider)new PackageRenderer(), types, filter);
        result.setMessage(ResourceUtil.getString(title));
        return result;
    }

    private TestSelectionDialog(Shell shell, TestNGLaunchConfigurationConstants.LaunchType type, IJavaProject jproject, ILabelProvider mainProvider, ILabelProvider detailsProvider, Object[] input, Filters.ITypeFilter filter) {
        super(shell, mainProvider, detailsProvider);
        this.m_testngType = type;
        this.m_project = jproject;
        this.m_input = input;
        this.m_filter = filter;
    }

    public int open() {
        if (this.m_input == null) {
            switch (this.m_testngType) {
                case CLASS: {
                    this.m_input = new IType[0];
                    try {
                        this.m_input = TestSearchEngine.findTests(new Object[]{this.m_project}, this.m_filter);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        return 1;
                    }
                    catch (InvocationTargetException e) {
                        TestNGPlugin.log(e.getTargetException());
                        return 1;
                    }
                }
                case SUITE: {
                    this.m_input = new IFile[0];
                    try {
                        this.m_input = TestSearchEngine.findSuites(new Object[]{this.m_project});
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        return 1;
                    }
                    catch (InvocationTargetException e) {
                        TestNGPlugin.log(e.getTargetException());
                        return 1;
                    }
                }
                case PACKAGE: {
                    this.m_input = new IType[0];
                    try {
                        this.m_input = TestSearchEngine.findPackages(new Object[]{this.m_project});
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        return 1;
                    }
                    catch (InvocationTargetException e) {
                        TestNGPlugin.log(e.getTargetException());
                        return 1;
                    }
                }
                default: {
                    throw new IllegalArgumentException("testng type not yet implemented: " + (Object)((Object)this.m_testngType));
                }
            }
        }
        this.setElements(this.m_input);
        return super.open();
    }

    private static class FileLabelProvider
    extends LabelProvider {
        public static final int SHOW_LABEL = 1;
        public static final int SHOW_LABEL_PATH = 2;
        public static final int SHOW_PATH_LABEL = 3;
        public static final int SHOW_PATH = 4;
        private static final String fgSeparatorFormat = "{0} - {1}";
        private WorkbenchLabelProvider fLabelProvider;
        private ILabelDecorator fDecorator;
        private int fOrder;
        private String[] fArgs = new String[2];

        public FileLabelProvider(int orderFlag) {
            this.fDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.fLabelProvider = new WorkbenchLabelProvider();
            this.fOrder = orderFlag;
        }

        public void setOrder(int orderFlag) {
            this.fOrder = orderFlag;
        }

        public String getText(Object element) {
            String decoratedText;
            if (!(element instanceof IResource)) {
                return "";
            }
            IResource resource = (IResource)element;
            String text = null;
            if (resource == null || !resource.exists()) {
                text = ResourceUtil.getString("SearchResultView.removed_resource");
            } else {
                IPath path = resource.getFullPath().removeLastSegments(1);
                if (path.getDevice() == null) {
                    path = path.makeRelative();
                }
                if (this.fOrder == 1 || this.fOrder == 2) {
                    text = this.fLabelProvider.getText((Object)resource);
                    if (path != null && this.fOrder == 2) {
                        this.fArgs[0] = text;
                        this.fArgs[1] = path.toString();
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                } else {
                    text = path != null ? path.toString() : "";
                    if (this.fOrder == 3) {
                        this.fArgs[0] = text;
                        this.fArgs[1] = this.fLabelProvider.getText((Object)resource);
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                }
            }
            if (this.fDecorator != null && (decoratedText = this.fDecorator.decorateText(text, (Object)resource)) != null) {
                return decoratedText;
            }
            return text;
        }

        public Image getImage(Object element) {
            Image decoratedImage;
            if (!(element instanceof IResource)) {
                return null;
            }
            IResource resource = (IResource)element;
            Image image = this.fLabelProvider.getImage((Object)resource);
            if (this.fDecorator != null && (decoratedImage = this.fDecorator.decorateImage(image, (Object)resource)) != null) {
                return decoratedImage;
            }
            return image;
        }

        public void dispose() {
            super.dispose();
            this.fLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fLabelProvider.isLabelProperty(element, property);
        }
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element instanceof IType) {
                result = super.getImage((Object)((IType)element).getPackageFragment());
            } else if (element instanceof File) {
                result = super.getImage(element);
            }
            return result;
        }

        public String getText(Object element) {
            String result = element.toString();
            if (element instanceof IType) {
                result = super.getText((Object)((IType)element).getPackageFragment());
            } else if (element instanceof File) {
                result = ((File)element).getName();
            }
            return result;
        }
    }
}

