/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.testng.eclipse.TestNGPlugin;
import org.testng.remote.strprotocol.AbstractRemoteTestRunnerClient;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class EclipseTestRunnerClient
extends AbstractRemoteTestRunnerClient {
    private StringMessageSender m_marshaller;

    @Deprecated
    public synchronized void startListening(IRemoteSuiteListener suiteListener, IRemoteTestListener testListener, int port) {
        this.m_marshaller = new StringMessageSender("localhost", port);
        try {
            this.m_marshaller.initReceiver();
            this.startListening(suiteListener, testListener, (IMessageSender)this.m_marshaller);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stopTest() {
        if (this.m_marshaller != null) {
            this.m_marshaller.shutDown();
            this.m_marshaller = null;
        }
        super.stopTest();
    }

    public synchronized void startListening(IRemoteSuiteListener suiteListener, IRemoteTestListener testListener, IMessageSender messageMarshaller) {
        AbstractRemoteTestRunnerClient.ServerConnection srvConnection = new AbstractRemoteTestRunnerClient.ServerConnection(this, messageMarshaller){

            protected void handleThrowable(Throwable cause) {
                TestNGPlugin.log(cause);
            }
        };
        this.startListening(new IRemoteSuiteListener[]{suiteListener}, new IRemoteTestListener[]{testListener}, srvConnection);
    }

    protected void notifyStart(final GenericMessage genericMessage) {
        int i = 0;
        while (i < this.m_suiteListeners.length) {
            final IRemoteSuiteListener listener = this.m_suiteListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.onInitialization(genericMessage);
                }
            });
            ++i;
        }
    }

    protected void notifySuiteEvents(final SuiteMessage suiteMessage) {
        int i = 0;
        while (i < this.m_suiteListeners.length) {
            final IRemoteSuiteListener listener = this.m_suiteListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (suiteMessage.isMessageOnStart()) {
                        listener.onStart(suiteMessage);
                    } else {
                        listener.onFinish(suiteMessage);
                    }
                }
            });
            ++i;
        }
    }

    protected void notifyTestEvents(final TestMessage testMessage) {
        int i = 0;
        while (i < this.m_testListeners.length) {
            final IRemoteTestListener listener = this.m_testListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (testMessage.isMessageOnStart()) {
                        listener.onStart(testMessage);
                    } else {
                        listener.onFinish(testMessage);
                    }
                }
            });
            ++i;
        }
    }

    protected void notifyResultEvents(final TestResultMessage testResultMessage) {
        int i = 0;
        while (i < this.m_testListeners.length) {
            final IRemoteTestListener listener = this.m_testListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    switch (testResultMessage.getResult()) {
                        case 1016: {
                            listener.onTestStart(testResultMessage);
                            break;
                        }
                        case 1001: {
                            listener.onTestSuccess(testResultMessage);
                            break;
                        }
                        case 1002: {
                            listener.onTestFailure(testResultMessage);
                            break;
                        }
                        case 1003: {
                            listener.onTestSkipped(testResultMessage);
                            break;
                        }
                        case 1004: {
                            listener.onTestFailedButWithinSuccessPercentage(testResultMessage);
                        }
                    }
                }
            });
            ++i;
        }
    }

    static abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        ListenerSafeRunnable() {
        }

        public void handleException(Throwable exception) {
            TestNGPlugin.log(exception);
        }
    }
}

