/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.SWTUtil;
import org.testng.eclipse.util.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGXmlPage
extends UserInputWizardPage {
    private static final String NAME = "testng.xml generation";
    private static final String TITLE = "Generate testng.xml";
    private Text m_previewText;
    private XmlSuite m_xmlSuite;
    private Text m_suiteText;
    private Text m_testText;
    private final ModifyListener MODIFY_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TestNGXmlPage.this.updateUi();
        }
    };
    private Combo m_selectionCombo;
    private Set<XmlClass> m_classes = Sets.newHashSet();
    private Set<XmlPackage> m_packages = Sets.newHashSet();
    private Text m_xmlFile;
    private Button m_generateBox;
    private Combo m_parallelCombo;
    private Text m_threadCountText;
    private Label m_codeGenerationBox;
    private Combo m_suiteMethodCombo;

    protected TestNGXmlPage() {
        super(NAME);
        this.setTitle(TITLE);
    }

    public void createControl(Composite p) {
        this.p("createUI");
        this.createUi(p);
        this.p("createModel");
        this.createModel();
        this.p("updateUI");
        this.updateUi();
        this.p("addListeners");
        this.addListeners();
    }

    private void p(String string) {
    }

    private void addListeners() {
        this.m_suiteText.addModifyListener(this.MODIFY_LISTENER);
        this.m_testText.addModifyListener(this.MODIFY_LISTENER);
        this.m_selectionCombo.addModifyListener(this.MODIFY_LISTENER);
        this.m_parallelCombo.addModifyListener(this.MODIFY_LISTENER);
        this.m_threadCountText.addModifyListener(this.MODIFY_LISTENER);
    }

    private String getDefaultSuiteName() {
        return "Suite";
    }

    private String getDefaultTestName() {
        return "Test";
    }

    private void updateUi() {
        this.m_xmlSuite.setName(this.m_suiteText.getText());
        ((XmlTest)this.m_xmlSuite.getTests().get(0)).setName(this.m_testText.getText());
        this.m_xmlSuite.setParallel(this.m_parallelCombo.getItem(this.m_parallelCombo.getSelectionIndex()));
        Integer threadCount = null;
        try {
            threadCount = Integer.parseInt(this.m_threadCountText.getText());
            this.m_xmlSuite.setThreadCount(threadCount.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            this.m_xmlSuite.setThreadCount(XmlSuite.DEFAULT_THREAD_COUNT.intValue());
        }
        this.updateXmlSuite(this.m_xmlSuite);
        this.m_previewText.setText(this.m_xmlSuite.toXml());
    }

    private void createUi(Composite wizardParent) {
        Composite control = new Composite(wizardParent, 0);
        SWTUtil.createGridLayout(control, 1);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_generateBox = new Button(control, 32);
        this.m_generateBox.setText(TITLE);
        this.m_generateBox.setSelection(true);
        final Group group = new Group(control, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gd);
        group.setEnabled(true);
        this.m_generateBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                group.setEnabled(((Button)e.getSource()).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite parent = SWTUtil.createGridContainer((Composite)group, 3);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_xmlFile = SWTUtil.createPathBrowserText(parent, "Location:", null);
        List<Utils.JavaElement> elements = Utils.getSelectedJavaElements();
        if (elements.size() > 0) {
            this.m_xmlFile.setText(elements.get(0).getProject().getPath() + "/testng.xml");
        }
        this.m_suiteText = this.addTextLabel(parent, "Suite name:");
        this.m_suiteText.setText(this.getDefaultSuiteName());
        this.m_testText = this.addTextLabel(parent, "Test name:");
        this.m_testText.setText(this.getDefaultTestName());
        Composite horizontal = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, true);
        horizontal.setLayout((Layout)layout);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 3;
        horizontal.setLayoutData((Object)gd2);
        Label l = new Label(horizontal, 0);
        l.setText("Class selection:");
        this.m_selectionCombo = new Combo(horizontal, 8);
        this.m_selectionCombo.add(Selection.CLASSES.toString());
        this.m_selectionCombo.add(Selection.PACKAGES.toString());
        this.m_selectionCombo.select(0);
        l = new Label(horizontal, 0);
        l.setText("Parallel mode:");
        this.m_parallelCombo = new Combo(horizontal, 8);
        this.m_parallelCombo.add("none");
        this.m_parallelCombo.add("methods");
        this.m_parallelCombo.add("classes");
        this.m_parallelCombo.add("tests");
        this.m_parallelCombo.select(0);
        l = new Label(horizontal, 0);
        l.setText("Thread count:");
        this.m_threadCountText = new Text(horizontal, 2048);
        Label previewLabelText = new Label(parent, 0);
        previewLabelText.setText("Preview");
        GridData gd3 = new GridData(4, 4, true, false);
        gd3.horizontalSpan = 3;
        previewLabelText.setLayoutData((Object)gd3);
        this.m_previewText = new Text(parent, 2816);
        gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 3;
        this.m_previewText.setLayoutData((Object)gd2);
        this.m_codeGenerationBox = new Label(control, 32);
        this.m_codeGenerationBox.setText("Code generation");
        Group group2 = new Group(control, 0);
        RowLayout gl = new RowLayout();
        group2.setLayout((Layout)gl);
        GridData gd4 = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)gd4);
        group2.setEnabled(true);
        Label l2 = new Label((Composite)group2, 0);
        l2.setText("suite() methods:");
        this.m_suiteMethodCombo = new Combo((Composite)group2, 8);
        this.m_suiteMethodCombo.add("Remove");
        this.m_suiteMethodCombo.add("Comment out");
        this.m_suiteMethodCombo.add("Don't touch");
        PreferenceStoreUtil.SuiteMethodTreatment lastValue = TestNGPlugin.getPluginPreferenceStore().getSuiteMethodTreatement();
        this.m_suiteMethodCombo.select(lastValue.ordinal());
        this.m_suiteMethodCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestNGPlugin.getPluginPreferenceStore().storeSuiteMethodTreatement(TestNGXmlPage.this.m_suiteMethodCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)control);
    }

    private void createModel() {
        HashSet packageSet = Sets.newHashSet();
        List<IType> types = Utils.findTypes(Utils.getSelectedJavaElements(), Utils.CONVERSION_FILTER);
        for (IType type : types) {
            String packageName = type.getPackageFragment().getElementName();
            String className = type.getElementName();
            if (className != null) {
                XmlClass c = new XmlClass(String.valueOf(packageName) + "." + className, false);
                this.p("Adding class " + c);
                this.m_classes.add(c);
                packageSet.add(packageName);
                continue;
            }
            this.p("Adding type " + type);
            this.m_classes.add(new XmlClass(type.getFullyQualifiedName(), false));
            packageSet.add(packageName);
        }
        for (String p : packageSet) {
            XmlPackage pkg = new XmlPackage();
            pkg.setName(p);
            this.p("Adding package " + p);
            this.m_packages.add(pkg);
        }
        this.m_xmlSuite = this.createXmlSuite();
    }

    private XmlSuite createXmlSuite() {
        XmlSuite result = new XmlSuite();
        result.setName(this.getDefaultSuiteName());
        XmlTest test = new XmlTest(result);
        test.setName(this.getDefaultTestName());
        this.updateXmlSuite(result);
        return result;
    }

    private void updateXmlSuite(XmlSuite suite) {
        this.p("Updating XML suite");
        XmlTest test = (XmlTest)suite.getTests().get(0);
        test.getXmlClasses().clear();
        test.getXmlPackages().clear();
        if (this.m_selectionCombo.getSelectionIndex() == 0) {
            test.getXmlClasses().addAll(this.m_classes);
        } else {
            test.getXmlPackages().addAll(this.m_packages);
        }
        this.p("Done updating XML suite");
    }

    private Text addTextLabel(Composite parent, String text) {
        Text result = SWTUtil.createLabelText(parent, text, null);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        result.setLayoutData((Object)gd);
        return result;
    }

    public boolean generateXmlFile() {
        return this.m_generateBox.getSelection();
    }

    public void saveXmlFile() {
        String path = this.m_xmlFile.getText();
        if (!path.endsWith(".xml")) {
            path = String.valueOf(path) + (path.endsWith("/") ? "testng.xml" : "/testng.xml");
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        ByteArrayInputStream is = new ByteArrayInputStream(this.m_xmlSuite.toXml().getBytes());
        try {
            org.testng.eclipse.ui.util.Utils.createFileWithDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), file, is);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        this.saveXmlFile();
    }

    static enum Selection {
        CLASSES("Classes"),
        PACKAGES("Packages");

        private String m_name;

        private Selection(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

