/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.testng.eclipse.util.Utils;
import org.testng.internal.Yaml;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

public class ConvertToYamlAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        for (Object o : selection) {
            IFile file;
            if (!(o instanceof IAdaptable) || (file = (IFile)((IAdaptable)o).getAdapter(IFile.class)) == null) continue;
            IPath location = file.getLocation();
            Parser p = new Parser(location.toOSString());
            p.setLoadClasses(false);
            try {
                Collection suites = p.parse();
                StringBuilder yamlSb = Yaml.toYaml((XmlSuite)((XmlSuite)suites.iterator().next()));
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                Path yamlPath = new Path(String.valueOf(file.getProject().getName()) + "/" + file.getProjectRelativePath().toString().replace(".xml", ".yaml"));
                IFile yamlFile = root.getFile((IPath)yamlPath);
                ByteArrayInputStream is = new ByteArrayInputStream(yamlSb.toString().getBytes("UTF-8"));
                yamlFile.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
                Utils.openFile(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), yamlFile, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

