/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.tester;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.testng.eclipse.launch.tester.FileExtender;
import org.testng.eclipse.launch.tester.JavaTypeExtender;

public class TestNGPropertyTester
extends PropertyTester {
    private static final Set<String> PROPERTIES = new HashSet<String>(){
        {
            this.add("isTest");
            this.add("isSuite");
            this.add("isXmlSuite");
        }
    };
    private static final boolean VERBOSE = false;
    private JavaTypeExtender m_typeExtender = new JavaTypeExtender();
    private FileExtender m_fileExtender = new FileExtender();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        TestNGPropertyTester.p("Testing property:" + property + " receiver:" + receiver);
        boolean result = false;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + receiver == null ? "null" : receiver.getClass().getName());
        }
        if (!PROPERTIES.contains(property)) {
            throw new IllegalArgumentException("Unknown test property '" + property + "'");
        }
        if ("isTest".equals(property)) {
            result = this.isTestClass(receiver, property, args, expectedValue);
        } else {
            boolean xmlOnly = "isXmlSuite".equals(property);
            result = this.isTestSuite(receiver, property, args, expectedValue, xmlOnly);
        }
        return result;
    }

    private boolean isTestClass(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IJavaElement) {
            return this.m_typeExtender.test(receiver, property, args, expectedValue);
        }
        IAdaptable adaptable = (IAdaptable)receiver;
        IJavaElement element = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
        if (element != null) {
            return this.m_typeExtender.test(element, property, args, expectedValue);
        }
        return false;
    }

    private boolean isTestSuite(Object receiver, String property, Object[] args, Object expectedValue, boolean xmlOnly) {
        if (receiver instanceof IFile) {
            return this.m_fileExtender.test(receiver, property, args, expectedValue, xmlOnly);
        }
        IAdaptable adaptable = (IAdaptable)receiver;
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        if (file != null) {
            return this.m_fileExtender.test(file, property, args, expectedValue, xmlOnly);
        }
        return false;
    }

    private static void p(String s) {
    }
}

