/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.TypeParser;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.LaunchUtil;
import org.testng.eclipse.util.SuiteFileValidator;

public abstract class AbstractTestNGLaunchDelegate
implements IEditorActionDelegate {
    private IAction m_action;
    private IEditorPart m_editorPart;
    private IProject m_project;
    private ICompilationUnit m_compilationUnit;
    private Map m_launchAttributes = new HashMap();
    private String m_configName;
    private String m_actionText = "";
    private boolean m_isSuite = false;
    private boolean m_enabled = false;

    protected abstract String getLaunchMode();

    protected abstract String getCommandPrefix();

    protected abstract String getTestShortcut();

    protected abstract String getSuiteShortcut();

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.m_action = action;
        this.m_editorPart = targetEditor;
        this.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void update() {
        if (this.m_action == null || this.m_editorPart == null) {
            return;
        }
        this.m_enabled = false;
        this.m_launchAttributes.clear();
        IEditorInput editorInput = this.m_editorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            this.m_project = file.getProject();
            this.m_actionText = this.getCommandPrefix();
            if ("java".equals(file.getFileExtension())) {
                this.m_actionText = String.valueOf(this.m_actionText) + " test";
                this.m_compilationUnit = JDTUtil.getJavaElement(file);
                IType[] types = this.getTypes(this.m_compilationUnit);
                IType mainType = this.getMainType(this.m_compilationUnit, types);
                if (types == null || mainType == null || !this.hasSource(mainType)) {
                    return;
                }
                ITestContent testContent = TypeParser.parseType(mainType);
                if (testContent.isTestNGClass()) {
                    this.m_enabled = true;
                    this.m_configName = mainType.getElementName();
                    this.m_launchAttributes = LaunchUtil.createClassLaunchConfigurationMap(mainType, types, testContent.getAnnotationType());
                }
            }
            this.m_action.setEnabled(this.m_enabled);
            this.m_action.setText(this.m_actionText);
        }
    }

    private IType getMainType(ICompilationUnit compilationUnit, IType[] types) {
        IType mainType = null;
        try {
            mainType = compilationUnit.findPrimaryType();
        }
        catch (AssertionFailedException assertionFailedException) {}
        if (mainType == null && types != null && types.length > 0) {
            mainType = types[0];
        }
        return mainType;
    }

    public void run(IAction action) {
        if (!this.m_enabled) {
            return;
        }
        LaunchUtil.launchMapConfiguration(this.m_project, this.m_configName, this.m_launchAttributes, this.m_compilationUnit, this.getLaunchMode());
    }

    protected IType[] getTypes(ICompilationUnit compilationUnit) {
        try {
            return compilationUnit.getTypes();
        }
        catch (JavaModelException jme) {
            TestNGPlugin.log(jme);
            return null;
        }
    }

    private boolean hasSource(IType type) {
        try {
            return type.getSource() != null;
        }
        catch (JavaModelException jme) {
            TestNGPlugin.log(jme);
            return false;
        }
    }

    protected boolean isSuiteDefinition(IFile file) {
        try {
            return SuiteFileValidator.isSuiteDefinition(file);
        }
        catch (CoreException ce) {
            TestNGPlugin.log(ce);
            return false;
        }
    }
}

