/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.util;

import java.lang.reflect.Method;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SWTUtil {
    private SWTUtil() {
    }

    public static void addTooltipOnPressSupport(Control control) {
        control.addMouseListener((MouseListener)new TooltipOnPressListener());
    }

    public static void addOnlyDigitInputSupport(Text text) {
        text.addVerifyListener((VerifyListener)new OnlyDigitsVerifyListener());
    }

    public static void addResizeSupport(Dialog dialog, IDialogSettings settings, String dialogKey) {
        Shell shell = dialog.getShell();
        ShellResizeSupportListener shellSupport = new ShellResizeSupportListener(dialog, settings, dialogKey);
        shell.addControlListener((ControlListener)shellSupport);
        shell.addShellListener((ShellListener)shellSupport);
        shell.addDisposeListener((DisposeListener)shellSupport);
    }

    private static final class OnlyDigitsVerifyListener
    implements VerifyListener {
        private OnlyDigitsVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            boolean doit = true;
            if (!Character.isDigit(e.character) && e.character != '\u007f' && e.character != '\b') {
                doit = false;
            }
            if (!doit) {
                try {
                    Integer.parseInt(e.text);
                    doit = true;
                }
                catch (NumberFormatException numberFormatException) {
                    doit = false;
                }
            }
            e.doit = doit;
            if (!e.doit) {
                Display.getCurrent().beep();
            }
        }
    }

    private static final class ShellResizeSupportListener
    extends ShellAdapter
    implements ControlListener,
    DisposeListener {
        private static final String X = "x";
        private static final String Y = "y";
        private static final String WIDTH = "width";
        private static final String HEIGHT = "height";
        private static final String MAXIMIZED = "maximized";
        private static final String MINIMIZED = "minimized";
        private Rectangle mNewBounds;
        private boolean mMaximized;
        private boolean mMinimized;
        private Dialog mDialog;
        private IDialogSettings mSettings;
        private String mDialogKey;
        private boolean mInitialyActivated = false;

        public ShellResizeSupportListener(Dialog dialog, IDialogSettings settings, String dialogKey) {
            this.mDialog = dialog;
            this.mSettings = settings;
            this.mDialogKey = dialogKey;
        }

        public void controlMoved(ControlEvent e) {
            this.controlResized(e);
        }

        public void controlResized(ControlEvent e) {
            Shell shell = (Shell)e.getSource();
            this.mMaximized = shell.getMaximized();
            this.mMinimized = shell.getMinimized();
            if (!this.mMinimized && !this.mMaximized) {
                this.mNewBounds = shell.getBounds();
            }
        }

        public void shellActivated(ShellEvent e) {
            if (!this.mInitialyActivated) {
                Point initialSize = null;
                try {
                    Method getInitialSizeMethod = Window.class.getDeclaredMethod("getInitialSize", new Class[]{null});
                    getInitialSizeMethod.setAccessible(true);
                    initialSize = (Point)getInitialSizeMethod.invoke((Object)this.mDialog, new Object[]{null});
                }
                catch (Exception exception) {
                    initialSize = new Point(0, 0);
                }
                Shell shell = (Shell)e.getSource();
                IDialogSettings bounds = this.mSettings.getSection(this.mDialogKey);
                if (bounds != null) {
                    this.mMaximized = bounds.getBoolean(MAXIMIZED);
                    this.mMinimized = bounds.getBoolean(MINIMIZED);
                    try {
                        this.mNewBounds = new Rectangle(bounds.getInt(X), bounds.getInt(Y), bounds.getInt(WIDTH), bounds.getInt(HEIGHT));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.mNewBounds = shell.getBounds();
                    }
                    shell.removeControlListener((ControlListener)this);
                    if (this.mNewBounds.width < initialSize.x) {
                        this.mNewBounds.width = initialSize.x;
                    }
                    if (this.mNewBounds.height < initialSize.y) {
                        this.mNewBounds.height = initialSize.y;
                    }
                    shell.setBounds(this.mNewBounds);
                    if (this.mMaximized) {
                        shell.setMaximized(true);
                    } else if (this.mMinimized) {
                        shell.setMinimized(true);
                    }
                    shell.addControlListener((ControlListener)this);
                }
                this.mInitialyActivated = true;
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            IDialogSettings bounds = this.mSettings.getSection(this.mDialogKey);
            if (bounds == null) {
                bounds = new DialogSettings(this.mDialogKey);
                this.mSettings.addSection(bounds);
            }
            if (this.mNewBounds != null) {
                bounds.put(WIDTH, this.mNewBounds.width);
                bounds.put(HEIGHT, this.mNewBounds.height);
                bounds.put(X, this.mNewBounds.x);
                bounds.put(Y, this.mNewBounds.y);
            }
            bounds.put(MAXIMIZED, this.mMaximized);
            bounds.put(MINIMIZED, this.mMinimized);
        }
    }

    private static final class TooltipOnPressListener
    extends MouseAdapter
    implements MouseTrackListener {
        private TooltipOnPressListener() {
        }

        public void mouseDown(MouseEvent e) {
            Control theControl = (Control)e.widget;
            Display display = theControl.getDisplay();
            Shell tip = new Shell(theControl.getShell(), 16388);
            tip.setBackground(display.getSystemColor(29));
            FillLayout layout = new FillLayout();
            layout.marginHeight = 1;
            layout.marginWidth = 2;
            tip.setLayout((Layout)layout);
            Label label = new Label((Composite)tip, 0);
            label.setForeground(display.getSystemColor(28));
            label.setBackground(display.getSystemColor(29));
            label.setText(theControl.getToolTipText());
            label.addMouseTrackListener((MouseTrackListener)this);
            Point size = tip.computeSize(-1, -1);
            Rectangle rect = theControl.getBounds();
            Point pt = theControl.getParent().toDisplay(rect.x, rect.y);
            tip.setBounds(pt.x, pt.y, size.x, size.y);
            tip.setVisible(true);
        }

        public void mouseExit(MouseEvent e) {
            Label label = (Label)e.widget;
            Shell shell = label.getShell();
            shell.dispose();
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }
    }
}

