/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.tracker.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.tools.usage.tracker.ILoggingAdapter;
import org.tigris.subversion.subclipse.tools.usage.util.LoggingUtils;

public class PluginLogger
implements ILoggingAdapter {
    private final boolean tracingEnabled;
    private Plugin plugin;

    public PluginLogger(Plugin plugin) {
        this.tracingEnabled = LoggingUtils.isPluginTracingEnabled(plugin);
        this.plugin = plugin;
    }

    public void logError(String message) {
        this.log(4, message);
    }

    public void logMessage(String message) {
        this.log(1, message);
    }

    private void log(int severity, String message) {
        if (!this.tracingEnabled) {
            return;
        }
        if (this.plugin != null) {
            Status status = new Status(severity, this.plugin.getBundle().getSymbolicName(), 0, message, null);
            this.plugin.getLog().log((IStatus)status);
        }
    }
}

