/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.actions;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooUiUtil;
import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.EclipseBambooBuildSelectionListenerAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.operations.RetrieveFullBuildInfoJob;
import com.atlassian.theplugin.commons.BambooFileInfo;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooChangeSet;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import java.util.Formatter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTaskFromFailedBuildAction
extends EclipseBambooBuildSelectionListenerAction {
    public NewTaskFromFailedBuildAction() {
        super(null);
        this.initialize();
    }

    private void initialize() {
        this.setText("New Task From Failed Build...");
        this.setToolTipText("New Task From Failed Build...");
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    void onRun(EclipseBambooBuild eclipseBambooBuild) {
        this.downloadAndCreateNewTask(eclipseBambooBuild);
    }

    boolean onUpdateSelection(EclipseBambooBuild eclipseBambooBuild) {
        return eclipseBambooBuild.getBuild().getStatus().equals((Object)BuildStatus.FAILURE);
    }

    private String createBuildDescription(BambooBuild build, String buildLog, BuildDetails buildDetails) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("\n-- Build %s-%d failed, please investigate and fix...\n", build.getPlanKey(), build.getNumber());
        fmt.format("\n-- Build result: %s\n", build.getResultUrl());
        if (buildDetails != null) {
            if (buildDetails.getCommitInfo() != null) {
                sb.append("\n-- Code changes:\n\n");
                for (BambooChangeSet changeSet : buildDetails.getCommitInfo()) {
                    fmt.format("[%s] %s\n", changeSet.getAuthor(), BambooUiUtil.getCommentSnippet(changeSet.getComment()));
                    if (changeSet.getFiles() == null) continue;
                    for (BambooFileInfo file : changeSet.getFiles()) {
                        sb.append('\t');
                        sb.append(file.getFileDescriptor().getAbsoluteUrl());
                        sb.append('\n');
                    }
                }
            }
            sb.append("\n-- Tests:\n");
            fmt.format("\nTests in total: %d, failed tests: %d\n", build.getTestsFailed() + build.getTestsPassed(), build.getTestsFailed());
            if (buildDetails.getFailedTestDetails() != null && buildDetails.getFailedTestDetails().size() > 0) {
                sb.append('\n');
                sb.append(BambooUiUtil.getFailedTestsDescription(buildDetails));
                sb.append('\n');
            }
        }
        int errorLines = 0;
        String[] buildLogLines = buildLog == null ? new String[]{} : buildLog.split("[\r\n]");
        StringBuilder errors = new StringBuilder();
        String[] stringArray = buildLogLines;
        int n = buildLogLines.length;
        int n2 = 0;
        while (n2 < n) {
            String buildLogLine = stringArray[n2];
            if (buildLogLine.startsWith("error")) {
                String[] lineElements = buildLogLine.split("\t");
                if (errorLines > 0) {
                    errors.append("\n");
                }
                int i = 2;
                while (i < lineElements.length) {
                    errors.append(lineElements[i]);
                    ++i;
                }
                ++errorLines;
            }
            ++n2;
        }
        fmt.format("\n-- Error lines:\n", errorLines);
        if (errorLines > 0) {
            sb.append('\n');
            sb.append((CharSequence)errors);
        } else {
            sb.append("\nBuild didn't generate any error lines.\n");
        }
        return sb.toString();
    }

    private void downloadAndCreateNewTask(EclipseBambooBuild eclipseBambooBuild) {
        final BambooBuild build = eclipseBambooBuild.getBuild();
        final RetrieveFullBuildInfoJob job = new RetrieveFullBuildInfoJob(build, eclipseBambooBuild.getTaskRepository());
        job.setUser(true);
        job.setPriority(10);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = job.getStatus();
                RetrieveFullBuildInfoJob infoJob = (RetrieveFullBuildInfoJob)event.getJob();
                if (infoJob.getBuildDetails() != null || infoJob.getBuildLog() != null) {
                    final String description = NewTaskFromFailedBuildAction.this.createBuildDescription(build, infoJob.getBuildLog(), infoJob.getBuildDetails());
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            TaskMapping taskMapping = new TaskMapping(){

                                public String getDescription() {
                                    return description;
                                }

                                public String getSummary() {
                                    StringBuilder sb = new StringBuilder();
                                    Formatter fmt = new Formatter(sb);
                                    fmt.format("Build %s-%d failed, please investigate and fix...", build.getPlanKey(), build.getNumber());
                                    return sb.toString();
                                }

                                public String getTaskUrl() {
                                    return build.getBuildUrl();
                                }
                            };
                            TasksUiUtil.openNewTaskEditor((Shell)shell, (ITaskMapping)taskMapping, null);
                        }
                    });
                } else {
                    StatusHandler.log((IStatus)status);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError(null, (String)NewTaskFromFailedBuildAction.this.getText(), (String)("Retrieving build details for " + build.getPlanKey() + "-" + build.getNumber() + " failed. See Error Log for details."));
                        }
                    });
                }
            }
        });
        job.schedule();
    }
}

