/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.builder.Auditor;
import net.sf.eclipsecs.core.jobs.RunCheckstyleOnFilesJob;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class AuditorJob
extends WorkspaceJob
implements ISchedulingRule {
    private IProject mProject;
    private Auditor mAuditor;

    public AuditorJob(IProject project, Auditor auditor) {
        super(NLS.bind((String)Messages.AuditorJob_msgBuildProject, (Object)project.getName()));
        this.mProject = project;
        this.mAuditor = auditor;
    }

    public boolean contains(ISchedulingRule arg0) {
        return arg0 instanceof AuditorJob;
    }

    public boolean isConflicting(ISchedulingRule arg0) {
        return arg0 instanceof AuditorJob || arg0 instanceof RunCheckstyleOnFilesJob;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            this.mAuditor.runAudit(this.mProject, monitor);
        }
        catch (CheckstylePluginException e) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }
}

