/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.wizards;

import com.atlassian.connector.eclipse.internal.commons.ui.dialogs.RemoteApiLockedDialog;
import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.CurrentUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.StatusFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraCaptchaRequiredException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.wizards.JiraFilterDefinitionPage;
import com.atlassian.connector.eclipse.internal.jira.ui.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;

public class JiraNamedFilterPage
extends AbstractRepositoryQueryPage {
    private static final String JIRA_STATUS_CLOSED = "6";
    private static final String JIRA_STATUS_RESOLVED = "5";
    private Button buttonCustom;
    private Button buttonSaved;
    private List savedFilterList;
    private NamedFilter[] filters = null;
    private JiraFilterDefinitionPage filterDefinitionPage;
    private final NamedFilter workingCopy;
    private Button buttonPredefined;
    private ListViewer projectList;
    private Button updateButton;
    private ListViewer predefinedFiltersList;
    private final JiraClient client;

    public JiraNamedFilterPage(TaskRepository repository) {
        this(repository, null);
    }

    public JiraNamedFilterPage(TaskRepository repository, IRepositoryQuery query) {
        super(Messages.JiraNamedFilterPage_New_Jira_Query, repository, query);
        this.workingCopy = this.getFilter(query);
        this.client = JiraClientFactory.getDefault().getJiraClient(repository);
        this.setTitle(Messages.JiraNamedFilterPage_New_Jira_Query);
        this.setDescription(Messages.JiraNamedFilterPage_Please_select_a_query_type);
        this.setPageComplete(false);
    }

    private NamedFilter getFilter(IRepositoryQuery query) {
        NamedFilter filter = null;
        if (query != null) {
            filter = JiraUtil.getNamedFilter((IRepositoryQuery)query);
        }
        if (filter == null) {
            filter = new NamedFilter();
        }
        return filter;
    }

    public void applyTo(IRepositoryQuery query) {
        NamedFilter filter = null;
        if (this.buttonSaved.getSelection()) {
            NamedFilter f = this.getSavedFilter();
            query.setSummary(f.getName());
            filter = f;
        } else if (this.buttonPredefined.getSelection()) {
            FilterDefinition f = this.getPredefinedFilter(query);
            filter = f;
        }
        JiraUtil.setQuery((TaskRepository)this.getTaskRepository(), (IRepositoryQuery)query, (JiraFilter)filter);
    }

    private FilterDefinition getPredefinedFilter(IRepositoryQuery query) {
        IStructuredSelection filterSelection;
        Object selected;
        FilterDefinition filter = new FilterDefinition();
        IStructuredSelection projectSelection = (IStructuredSelection)this.projectList.getSelection();
        if (projectSelection != null && !projectSelection.isEmpty() && (selected = projectSelection.getFirstElement()) instanceof Project) {
            filter.setProjectFilter(new ProjectFilter((Project)selected));
        }
        if ((filterSelection = (IStructuredSelection)this.predefinedFiltersList.getSelection()) != null && !filterSelection.isEmpty()) {
            PredefinedFilter selected2 = (PredefinedFilter)((Object)filterSelection.getFirstElement());
            query.setSummary(this.getQueryTitle());
            switch (selected2) {
                case ADDED_RECENTLY: {
                    filter.setCreatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
                    break;
                }
                case UPDATED_RECENTLY: {
                    filter.setUpdatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
                    break;
                }
                case RESOLVED_RECENTLY: {
                    filter.setUpdatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
                    ArrayList<JiraStatus> statuses = new ArrayList<JiraStatus>();
                    JiraStatus[] jiraStatusArray = this.client.getCache().getStatuses();
                    int n = jiraStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JiraStatus status = jiraStatusArray[n2];
                        if (status.getId().equals(JIRA_STATUS_RESOLVED) || status.getId().equals(JIRA_STATUS_CLOSED)) {
                            statuses.add(status);
                        }
                        ++n2;
                    }
                    filter.setStatusFilter(new StatusFilter(statuses.toArray(new JiraStatus[statuses.size()])));
                    break;
                }
                case ASSIGNED_TO_ME: {
                    filter.setResolutionFilter(new ResolutionFilter(new Resolution[0]));
                    filter.setAssignedToFilter((UserFilter)new CurrentUserFilter());
                    break;
                }
                case REPORTED_BY_ME: {
                    filter.setReportedByFilter((UserFilter)new CurrentUserFilter());
                }
            }
        }
        return filter;
    }

    public boolean canFlipToNextPage() {
        return this.buttonCustom.getSelection();
    }

    public void createControl(Composite parent) {
        IRepositoryQuery query = this.getQuery();
        boolean isCustom = query == null || JiraUtil.isFilterDefinition((IRepositoryQuery)query);
        Composite innerComposite = new Composite(parent, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout(2, true);
        innerComposite.setLayout((Layout)gl);
        this.buttonCustom = new Button(innerComposite, 16);
        this.buttonCustom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonCustom.setText(Messages.JiraNamedFilterPage_Create_query_using_form);
        this.buttonCustom.setSelection(isCustom);
        this.buttonCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                JiraNamedFilterPage.this.updateButton.setEnabled(!JiraNamedFilterPage.this.buttonCustom.getSelection());
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.buttonCustom.setEnabled(query == null || isCustom);
        this.buttonSaved = new Button(innerComposite, 16);
        this.buttonSaved.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonSaved.setText(Messages.JiraNamedFilterPage_Use_saved_filter_from_the_repository);
        this.buttonSaved.setSelection(!isCustom);
        this.buttonSaved.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                boolean selection = JiraNamedFilterPage.this.buttonSaved.getSelection();
                if (JiraNamedFilterPage.this.filters != null && JiraNamedFilterPage.this.filters.length > 0) {
                    JiraNamedFilterPage.this.savedFilterList.setEnabled(selection);
                }
                JiraNamedFilterPage.this.updateButton.setEnabled(!JiraNamedFilterPage.this.buttonCustom.getSelection());
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.buttonSaved.setEnabled(query == null || !isCustom);
        this.savedFilterList = new List(innerComposite, 2560);
        this.savedFilterList.add(Messages.JiraNamedFilterPage_Downloading_);
        this.savedFilterList.deselectAll();
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.horizontalIndent = 15;
        gd.minimumHeight = 90;
        gd.heightHint = 90;
        this.savedFilterList.setLayoutData((Object)gd);
        this.savedFilterList.setEnabled(!isCustom);
        this.savedFilterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.updateButton.setEnabled(!JiraNamedFilterPage.this.buttonCustom.getSelection());
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.buttonPredefined = new Button(innerComposite, 16);
        this.buttonPredefined.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonPredefined.setText(Messages.JiraNamedFilterPage_Use_project_specific_predefined_filter);
        this.buttonPredefined.setSelection(false);
        this.buttonPredefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                boolean selection = JiraNamedFilterPage.this.buttonPredefined.getSelection();
                JiraNamedFilterPage.this.projectList.getControl().setEnabled(selection);
                JiraNamedFilterPage.this.predefinedFiltersList.getControl().setEnabled(selection);
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.buttonPredefined.setEnabled(query == null || !isCustom);
        this.projectList = new ListViewer(innerComposite, 2560);
        this.projectList.add((Object)Messages.JiraNamedFilterPage_Downloading_);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 15;
        gd.minimumHeight = 90;
        gd.heightHint = 90;
        this.projectList.getControl().setLayoutData((Object)gd);
        this.projectList.getControl().setEnabled(false);
        this.projectList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.predefinedFiltersList = new ListViewer(innerComposite, 2560);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 15;
        gd.minimumHeight = 90;
        gd.heightHint = 90;
        this.predefinedFiltersList.getControl().setLayoutData((Object)gd);
        this.predefinedFiltersList.getControl().setEnabled(false);
        this.predefinedFiltersList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.updateButton = new Button(innerComposite, 16392);
        gd = new GridData(16384, 128, false, true);
        gd.horizontalIndent = 15;
        this.updateButton.setLayoutData((Object)gd);
        this.updateButton.setText(Messages.JiraNamedFilterPage_Update_from_Repository);
        this.updateButton.setEnabled(!isCustom);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                JiraNamedFilterPage.this.updateButton.setEnabled(false);
                if (JiraNamedFilterPage.this.buttonSaved.getSelection()) {
                    JiraNamedFilterPage.this.savedFilterList.getSelection();
                    JiraNamedFilterPage.this.savedFilterList.setEnabled(false);
                    JiraNamedFilterPage.this.savedFilterList.removeAll();
                    JiraNamedFilterPage.this.savedFilterList.add(Messages.JiraNamedFilterPage_Downloading_);
                    JiraNamedFilterPage.this.savedFilterList.deselectAll();
                    JiraNamedFilterPage.this.getContainer().updateButtons();
                    JiraNamedFilterPage.this.downloadFilters();
                    JiraNamedFilterPage.this.getContainer().updateButtons();
                } else if (JiraNamedFilterPage.this.buttonPredefined.getSelection()) {
                    JiraNamedFilterPage.this.projectList.getControl().setEnabled(false);
                    JiraNamedFilterPage.this.getContainer().updateButtons();
                    JiraNamedFilterPage.this.downloadProjects();
                    JiraNamedFilterPage.this.projectList.getControl().setEnabled(JiraNamedFilterPage.this.buttonPredefined.getSelection());
                    JiraNamedFilterPage.this.getContainer().updateButtons();
                }
                JiraNamedFilterPage.this.updateButton.setEnabled(true);
            }
        });
        this.initializeProjects();
        this.initializePredefinedFilters();
        Dialog.applyDialogFont((Control)innerComposite);
        this.setControl((Control)innerComposite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (JiraNamedFilterPage.this.downloadFilters() && !JiraNamedFilterPage.this.client.getCache().hasDetails()) {
                        boolean projectListEnabled = JiraNamedFilterPage.this.projectList.getControl().getEnabled();
                        boolean updateProjectsButtonEnabled = JiraNamedFilterPage.this.updateButton.getEnabled();
                        JiraNamedFilterPage.this.projectList.getControl().setEnabled(false);
                        JiraNamedFilterPage.this.updateButton.setEnabled(false);
                        JiraNamedFilterPage.this.downloadProjects();
                        JiraNamedFilterPage.this.projectList.getControl().setEnabled(projectListEnabled);
                        JiraNamedFilterPage.this.updateButton.setEnabled(updateProjectsButtonEnabled);
                    }
                    JiraNamedFilterPage.this.projectList.setInput((Object)JiraNamedFilterPage.this.client.getCache().getProjects());
                }
            });
        }
    }

    private void initializeProjects() {
        this.projectList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Project[] projects = (Project[])inputElement;
                Object[] elements = new Object[projects.length + 1];
                elements[0] = Messages.JiraFilterDefinitionPage_All_Projects;
                System.arraycopy(projects, 0, elements, 1, projects.length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                return ((Project)element).getName();
            }
        });
    }

    private void initializePredefinedFilters() {
        this.predefinedFiltersList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (PredefinedFilter[])inputElement;
            }
        });
        this.predefinedFiltersList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((PredefinedFilter)((Object)element)).getName();
            }
        });
        this.predefinedFiltersList.setInput((Object)PredefinedFilter.values());
    }

    public void displayFilters(NamedFilter[] filters) {
        this.savedFilterList.removeAll();
        if (filters.length == 0) {
            this.savedFilterList.setEnabled(false);
            this.savedFilterList.add(Messages.JiraNamedFilterPage_No_filters_found);
            this.savedFilterList.deselectAll();
            return;
        }
        int n = 0;
        int i = 0;
        while (i < filters.length) {
            this.savedFilterList.add(filters[i].getName());
            if (filters[i].getId().equals(this.workingCopy.getId())) {
                n = i;
            }
            ++i;
        }
        this.savedFilterList.select(n);
        this.savedFilterList.showSelection();
        this.savedFilterList.setEnabled(this.buttonSaved.getSelection());
        this.setPageComplete(true);
    }

    private void showFilters(final NamedFilter[] loadedFilters) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!JiraNamedFilterPage.this.savedFilterList.isDisposed()) {
                    JiraNamedFilterPage.this.displayFilters(loadedFilters);
                }
            }
        });
    }

    protected boolean downloadFilters() {
        final boolean[] results = new boolean[1];
        IRunnableWithProgress job = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                NamedFilter[] loadedFilters = new NamedFilter[]{};
                try {
                    try {
                        monitor.beginTask(Messages.JiraNamedFilterPage_Downloading_list_of_filters, -1);
                        JiraClient jiraServer = JiraClientFactory.getDefault().getJiraClient(JiraNamedFilterPage.this.getTaskRepository());
                        loadedFilters = jiraServer.getNamedFilters(monitor);
                        JiraNamedFilterPage.this.filters = loadedFilters;
                        results[0] = true;
                    }
                    catch (JiraCaptchaRequiredException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                new RemoteApiLockedDialog(WorkbenchUtil.getShell(), JiraNamedFilterPage.this.getTaskRepository().getRepositoryUrl()).open();
                            }
                        });
                        JiraNamedFilterPage.this.handleError(e, Messages.JiraNamedFilterPage_Could_not_update_filters);
                        JiraNamedFilterPage.this.showFilters(loadedFilters);
                        monitor.done();
                    }
                    catch (JiraException e) {
                        JiraNamedFilterPage.this.handleError(e, Messages.JiraNamedFilterPage_Could_not_update_filters);
                        JiraNamedFilterPage.this.showFilters(loadedFilters);
                        monitor.done();
                    }
                }
                finally {
                    JiraNamedFilterPage.this.showFilters(loadedFilters);
                    monitor.done();
                }
            }
        };
        try {
            this.getRunnableContext().run(true, true, job);
        }
        catch (Exception e) {
            this.handleError(e, Messages.JiraNamedFilterPage_Could_not_update_filters);
        }
        return results[0];
    }

    private IRunnableContext getRunnableContext() {
        IWizardContainer context = this.getContainer();
        if (context == null) {
            context = this.getSearchContainer().getRunnableContext();
        }
        if (context == null) {
            context = PlatformUI.getWorkbench().getProgressService();
        }
        return context;
    }

    private boolean downloadProjects() {
        final boolean[] results = new boolean[1];
        ISelection selection = this.projectList.getSelection();
        IRunnableWithProgress job = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.JiraNamedFilterPage_Downloading_Projects, -1);
                try {
                    try {
                        JiraNamedFilterPage.this.client.getCache().refreshDetails(monitor);
                        results[0] = true;
                    }
                    catch (JiraCaptchaRequiredException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                new RemoteApiLockedDialog(WorkbenchUtil.getShell(), JiraNamedFilterPage.this.getTaskRepository().getRepositoryUrl()).open();
                            }
                        });
                        JiraNamedFilterPage.this.handleError(e, Messages.JiraNamedFilterPage_Download_Projects_Failed);
                        monitor.done();
                    }
                    catch (JiraException e) {
                        JiraNamedFilterPage.this.handleError(e, Messages.JiraNamedFilterPage_Download_Projects_Failed);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getRunnableContext().run(true, true, job);
        }
        catch (Exception e) {
            this.handleError(e, Messages.JiraNamedFilterPage_Download_Projects_Failed);
        }
        this.projectList.setInput((Object)this.client.getCache().getProjects());
        this.projectList.setSelection(selection, true);
        return results[0];
    }

    protected void handleError(final Throwable e, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.jira.ui", message, e));
                JiraNamedFilterPage.this.setErrorMessage(String.valueOf(message) + ": " + e.getMessage());
            }
        });
    }

    public IWizardPage getNextPage() {
        if (this.buttonSaved.getSelection() || this.buttonPredefined.getSelection()) {
            return null;
        }
        if (this.filterDefinitionPage == null) {
            this.filterDefinitionPage = new JiraFilterDefinitionPage(this.getTaskRepository(), this.getQuery());
            if (this.getWizard() instanceof Wizard) {
                ((Wizard)this.getWizard()).addPage((IWizardPage)this.filterDefinitionPage);
            }
        }
        return this.filterDefinitionPage;
    }

    public String getQueryTitle() {
        IStructuredSelection filterSelection;
        if (this.buttonSaved.getSelection()) {
            return this.getSavedFilter() != null ? this.getSavedFilter().getName() : null;
        }
        if (this.buttonPredefined.getSelection() && (filterSelection = (IStructuredSelection)this.predefinedFiltersList.getSelection()) != null && !filterSelection.isEmpty()) {
            PredefinedFilter selected = (PredefinedFilter)((Object)filterSelection.getFirstElement());
            IStructuredSelection projectSelection = (IStructuredSelection)this.projectList.getSelection();
            if (projectSelection != null && !projectSelection.isEmpty()) {
                Object project = projectSelection.getFirstElement();
                String projectName = null;
                if (project instanceof String) {
                    projectName = (String)project;
                } else if (project instanceof Project) {
                    projectName = ((Project)project).getName();
                }
                if (projectName != null) {
                    return String.valueOf(selected.getName()) + " (" + projectName + ")";
                }
            }
            return selected.getName();
        }
        return null;
    }

    private NamedFilter getSavedFilter() {
        if (this.filters != null && this.filters.length > 0 && this.savedFilterList.getSelectionIndex() >= 0) {
            return this.filters[this.savedFilterList.getSelectionIndex()];
        }
        return null;
    }

    public boolean isPageComplete() {
        boolean ret = false;
        if (this.buttonSaved.getSelection() && this.savedFilterList.getSelectionCount() == 1) {
            ret = true;
        } else if (this.buttonPredefined.getSelection() && this.projectList.getList().getSelectionCount() == 1 && this.predefinedFiltersList.getList().getSelectionCount() == 1) {
            ret = true;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PredefinedFilter {
        ASSIGNED_TO_ME(Messages.JiraNamedFilterPage_Predefined_filter_assigned_to_me),
        REPORTED_BY_ME(Messages.JiraNamedFilterPage_Predefined_filter_reported_by_me),
        ADDED_RECENTLY(Messages.JiraNamedFilterPage_Predefined_filter_added_recently),
        UPDATED_RECENTLY(Messages.JiraNamedFilterPage_Predefined_filter_updated_recently),
        RESOLVED_RECENTLY(Messages.JiraNamedFilterPage_Predefined_filter_resolved_recently);

        private String name;

        private PredefinedFilter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

