/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.ui.actions.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class JiraUiUtil {
    public static long getLoggedActivityTime(ITask iTask) {
        long mylynTimeTicks = TasksUiPlugin.getTaskActivityManager().getElapsedTime(iTask);
        long localTimeTicks = 0L;
        String stringLoggedTime = iTask.getAttribute("attribute.jira.loggedActivityTime");
        if (stringLoggedTime != null && stringLoggedTime.length() > 0) {
            try {
                localTimeTicks = Long.parseLong(stringLoggedTime);
            }
            catch (NumberFormatException e) {
                StatusHandler.log((IStatus)new Status(2, "Atlassian JIRA Connector", Messages.JiraUiUtil_Cannot_parse_logged_activity_time, (Throwable)e));
            }
        }
        if (mylynTimeTicks >= localTimeTicks) {
            return (mylynTimeTicks - localTimeTicks) / 1000L;
        }
        StatusHandler.log((IStatus)new Status(2, "Atlassian JIRA Connector", String.valueOf(Messages.JiraUiUtil_Logged_activity_time_problem) + iTask.getTaskKey()));
        return mylynTimeTicks / 1000L;
    }

    public static void clearLoggedActivityTime(ITask task) {
        task.setAttribute("attribute.jira.loggedActivityTime", "");
    }

    public static void setLoggedActivityTime(ITask task) {
        task.setAttribute("attribute.jira.loggedActivityTime", Long.toString(TasksUiPlugin.getTaskActivityManager().getElapsedTime(task)));
    }

    public static void updateAdjustEstimateOption(JiraWorkLog.AdjustEstimateMethod adjustEstimate, TaskRepository repository) {
        repository.setProperty("attribute.adjust-estimate", adjustEstimate.value());
    }

    public static JiraWorkLog.AdjustEstimateMethod getAdjustEstimateOption(TaskRepository repository) {
        try {
            return JiraWorkLog.AdjustEstimateMethod.fromValue((String)repository.getProperty("attribute.adjust-estimate"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return JiraWorkLog.AdjustEstimateMethod.LEAVE;
        }
    }
}

