/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.monitor.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

public abstract class AbstractMonitorLog {
    protected File outputFile;
    protected FileOutputStream outputStream;
    protected boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring() {
        AbstractMonitorLog abstractMonitorLog = this;
        synchronized (abstractMonitorLog) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        try {
            if (!this.outputFile.exists()) {
                this.outputFile.createNewFile();
            }
            this.outputStream = new FileOutputStream(this.outputFile, true);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Could not log to file: " + this.outputFile.getAbsolutePath(), (Throwable)e));
        }
    }

    public void stopMonitoring() {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            this.started = false;
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Could not close interaction event stream", (Throwable)e));
        }
    }

    public File moveOutputFile(String newPath) {
        this.stopMonitoring();
        File newFile = new File(newPath);
        try {
            if (this.outputFile.exists() && !newFile.exists()) {
                this.outputFile.renameTo(newFile);
            } else if (!newFile.exists()) {
                newFile.createNewFile();
                this.outputFile.delete();
            } else {
                this.outputFile.delete();
            }
            this.outputFile = newFile;
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Could not set logger output file", (Throwable)e));
        }
        this.startMonitoring();
        return newFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

