/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.mylyn;

import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.mylyn.SubclipseTeamPlugin;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;

class SubclipseLinkedTaskInfo
extends AbstractTaskReference {
    private IResource resource;
    private CheckedInChangeSet changeSet;
    private LogEntry logEntry;
    private String repositoryUrl;
    private String taskFullUrl;
    private String comment;

    SubclipseLinkedTaskInfo(IResource resource, CheckedInChangeSet changeSet) {
        this.resource = resource;
        this.changeSet = changeSet;
    }

    SubclipseLinkedTaskInfo(LogEntry logEntry) {
        this.logEntry = logEntry;
        this.comment = logEntry.getComment();
    }

    public String getRepositoryUrl() {
        if (this.repositoryUrl == null) {
            this.init();
        }
        return this.repositoryUrl;
    }

    public String getTaskUrl() {
        if (this.taskFullUrl == null) {
            this.init();
        }
        return this.taskFullUrl;
    }

    public AbstractTask getTask() {
        return null;
    }

    public String getTaskId() {
        return null;
    }

    public String getText() {
        if (this.comment == null && this.changeSet != null) {
            try {
                SyncInfoTree syncInfoSet = this.changeSet.getSyncInfoSet();
                SVNStatusSyncInfo info = (SVNStatusSyncInfo)syncInfoSet.getSyncInfo(this.resource);
                ISVNRemoteResource remoteResource = (ISVNRemoteResource)info.getRemote();
                SVNRevision.Number rev = remoteResource.getLastChangedRevision();
                ISVNLogMessage[] messages = remoteResource.getLogMessages((SVNRevision)rev, (SVNRevision)rev, SVNRevision.START, false, false, 1L, false);
                this.comment = messages[0].getMessage();
            }
            catch (TeamException teamException) {
                this.comment = this.changeSet.getComment();
            }
        }
        return this.comment;
    }

    private void init() {
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        String[] urls = null;
        ProjectProperties props = null;
        try {
            ISVNResource svnres;
            if (this.resource != null) {
                props = ProjectProperties.getProjectProperties((IResource)this.resource);
            } else if (this.logEntry != null && (svnres = this.logEntry.getResource()) != null) {
                if (svnres.getResource() != null) {
                    props = ProjectProperties.getProjectProperties((IResource)svnres.getResource());
                } else {
                    ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                    SVNProviderPlugin.disableConsoleLogging();
                    ISVNProperty[] properties = client.getProperties(svnres.getUrl());
                    SVNProviderPlugin.enableConsoleLogging();
                    int i = 0;
                    while (i < properties.length) {
                        ISVNProperty property = properties[i];
                        if ("bugtraq:url".equals(property.getName())) {
                            this.repositoryUrl = SubclipseTeamPlugin.getRepository(property.getValue(), (IRepositoryManager)repositoryManager).getRepositoryUrl();
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception exception) {
            SVNProviderPlugin.enableConsoleLogging();
        }
        if (props != null) {
            if (this.repositoryUrl == null) {
                this.repositoryUrl = SubclipseTeamPlugin.getRepository(props.getUrl(), (IRepositoryManager)repositoryManager).getRepositoryUrl();
            }
            urls = props.getLinkList(this.getText()).getUrls();
        }
        if (urls == null || urls.length == 0) {
            urls = ProjectProperties.getUrls((String)this.getText()).getUrls();
        }
        if (urls != null && urls.length > 0) {
            this.taskFullUrl = urls[0];
        }
    }
}

