/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.ui.commons;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public final class AtlassianUiUtil {
    private AtlassianUiUtil() {
    }

    public static boolean ensureViewIsVisible(String viewId) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if (view.getId().equals(viewId)) {
                return true;
            }
            ++n2;
        }
        try {
            activePage.showView(viewId, null, 1);
            return true;
        }
        catch (PartInitException partInitException) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.ui", "Could not initialize " + viewId + " view."));
            return false;
        }
    }

    public static boolean showViewInActiveWorkbenchPage(String viewId) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        try {
            activePage.showView(viewId);
            return true;
        }
        catch (PartInitException partInitException) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.ui", "Could not initialize " + viewId + " view."));
            return false;
        }
    }

    public static LineRange getSelectedLineNumberRangeFromEditorInput(IEditorPart editor, IEditorInput editorInput) {
        if (editor instanceof ITextEditor && editor.getEditorInput() == editorInput) {
            ISelection selection = ((ITextEditor)editor).getSelectionProvider().getSelection();
            return AtlassianUiUtil.getLineRange(selection);
        }
        if (editor.getAdapter(ITextEditor.class) != null) {
            ISelection selection = ((ITextEditor)editor.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
            return AtlassianUiUtil.getLineRange(selection);
        }
        return null;
    }

    private static LineRange getLineRange(ISelection selection) {
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            return new LineRange(textSelection.getStartLine() + 1, textSelection.getEndLine() - textSelection.getStartLine() + 1);
        }
        return null;
    }
}

