/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.ide.eclipse.core.java.classreading.JdtMetadataReaderException;
import org.springframework.ide.eclipse.core.java.classreading.JdtMetadataReaderFactory;

public class CachingJdtMetadataReaderFactory
implements MetadataReaderFactory {
    private final JdtMetadataReaderFactory factory;
    private final Map<String, MetadataReader> cache = new HashMap<String, MetadataReader>();

    public CachingJdtMetadataReaderFactory(IJavaProject project, ClassLoader classloader) {
        this.factory = new JdtMetadataReaderFactory(project, classloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReader getMetadataReader(String className) throws IOException {
        Map<String, MetadataReader> map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(className)) {
                this.cache.put(className, this.factory.getMetadataReader(className));
            }
        }
        return this.cache.get(className);
    }

    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        throw new JdtMetadataReaderException("'getMetadataReader' is not supported");
    }
}

