/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.PersistablePreferenceObjectSupport;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidator;
import org.springframework.ide.eclipse.core.model.validation.IValidator;
import org.springframework.util.StringUtils;

public class ValidatorDefinition
extends PersistablePreferenceObjectSupport {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String ENABLEMENT_PREFIX = "validator.enable.";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MARKER_ID_ATTRIBUTE = "markerId";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ORDER_ATTRIBUTE = "order";
    private String description;
    private String iconUri;
    private String id;
    private String markerId;
    private String name;
    private String namespaceUri;
    private int order;
    private IValidator validator;

    public ValidatorDefinition(IConfigurationElement element) throws CoreException {
        this.init(element);
    }

    private void cleanup(IProject project) {
        if (!this.isEnabled(project)) {
            if (project != null) {
                MarkerUtils.deleteMarkers((IResource)project, this.markerId);
            } else {
                Set<ISpringProject> projects = SpringCore.getModel().getProjects();
                for (ISpringProject sproject : projects) {
                    IProject p = sproject.getProject();
                    if (this.hasProjectSpecificOptions(p)) continue;
                    MarkerUtils.deleteMarkers((IResource)p, this.markerId);
                }
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getID() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    protected String getPreferenceId() {
        return ENABLEMENT_PREFIX + this.id;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    private void init(IConfigurationElement element) throws CoreException {
        Object executable = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (executable instanceof IValidator) {
            this.validator = (IValidator)executable;
        }
        this.id = String.valueOf(element.getContributor().getName()) + "." + element.getAttribute(ID_ATTRIBUTE);
        this.name = element.getAttribute(NAME_ATTRIBUTE);
        this.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        this.iconUri = element.getAttribute(ICON_ATTRIBUTE);
        String orderString = element.getAttribute(ORDER_ATTRIBUTE);
        this.order = StringUtils.hasText((String)orderString) ? Integer.valueOf(orderString) : Integer.MAX_VALUE;
        this.markerId = String.valueOf(element.getContributor().getName()) + "." + element.getAttribute(MARKER_ID_ATTRIBUTE);
        this.namespaceUri = element.getDeclaringExtension().getNamespaceIdentifier();
        String enabledByDefault = element.getAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE);
        if (enabledByDefault != null) {
            this.setEnabledByDefault(Boolean.valueOf(enabledByDefault));
        } else {
            this.setEnabledByDefault(true);
        }
        this.initValidator();
    }

    private void initValidator() {
        if (this.validator instanceof AbstractValidator) {
            ((AbstractValidator)this.validator).setMarkerId(this.markerId);
            ((AbstractValidator)this.validator).setValidatorId(this.id);
        }
    }

    @Override
    protected void onEnablementChanged(boolean isEnabled, IProject project) {
        this.cleanup(project);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.validator.getClass().getName() + ")";
    }
}

