/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.core.internal.model.SpringModel;
import org.springframework.ide.eclipse.core.java.ITypeStructureCache;
import org.springframework.ide.eclipse.core.java.TypeStructureCache;
import org.springframework.ide.eclipse.core.java.typehierarchy.BytecodeTypeHierarchyClassReaderFactory;
import org.springframework.ide.eclipse.core.java.typehierarchy.DirectTypeHierarchyElementCacheFactory;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyResourceChangeListener;
import org.springframework.ide.eclipse.core.model.ISpringModel;

public class SpringCore
extends Plugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.core";
    public static final String BUILDER_ID = "org.springframework.ide.eclipse.core.springbuilder";
    public static final String NATURE_ID = "org.springframework.ide.eclipse.core.springnature";
    public static final String MARKER_ID = "org.springframework.ide.eclipse.core.problemmarker";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.core.messages";
    public static final String PROJECT_PROPERTY_ID = "enable.project.preferences";
    public static final String USE_CHANGE_DETECTION_IN_JAVA_FILES = "org.springframework.ide.eclipse.core.useChangeDetectionForJavaFiles";
    public static final String USE_NON_LOCKING_CLASSLOADER = "org.springframework.ide.eclipse.core.useNonLockingClassLoader";
    private static SpringCore plugin;
    private static SpringModel model;
    private ResourceBundle resourceBundle;
    private static TypeStructureCache typeStructureCache;
    private static TypeHierarchyEngine typeHierarchyEngine;

    public SpringCore() {
        plugin = this;
        model = new SpringModel();
        typeStructureCache = new TypeStructureCache();
        typeHierarchyEngine = new TypeHierarchyEngine(true);
        typeHierarchyEngine.setClassReaderFactory(new BytecodeTypeHierarchyClassReaderFactory());
        typeHierarchyEngine.setTypeHierarchyElementCacheFactory(new DirectTypeHierarchyElementCacheFactory());
        TypeHierarchyResourceChangeListener resetListener = new TypeHierarchyResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)resetListener, 8);
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        model.startup();
        typeStructureCache.startup();
        plugin.getPluginPreferences().setDefault(USE_CHANGE_DETECTION_IN_JAVA_FILES, true);
        plugin.getPluginPreferences().setDefault(USE_NON_LOCKING_CLASSLOADER, false);
    }

    public void stop(BundleContext context) throws Exception {
        model.shutdown();
        typeStructureCache.shutdown();
        super.stop(context);
    }

    public static SpringCore getDefault() {
        return plugin;
    }

    public static final ISpringModel getModel() {
        return model;
    }

    public static final ITypeStructureCache getTypeStructureCache() {
        return typeStructureCache;
    }

    public static final TypeHierarchyEngine getTypeHierarchyEngine() {
        return typeHierarchyEngine;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = SpringCore.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                SpringCore.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        SpringCore.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = SpringCore.createErrorStatus(message, exception);
        SpringCore.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        SpringCore.getDefault().getLog().log(SpringCore.createErrorStatus(SpringCore.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, Object ... args) {
        return MessageFormat.format(SpringCore.getResourceString(key), args);
    }
}

