/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.BuildType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentManager;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.Describable;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GSContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GettingStartedContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GettingStartedGuide;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.MultiSelectionModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportConfiguration;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportUtils;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveSet;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.ui.UiUtil;

public class GSImportWizardModel {
    private ContentManager contentManager = GettingStartedContent.getInstance();
    private final LiveVariable<GSContent> guide = new LiveVariable();
    private final LiveVariable<Object> rawSelection = new LiveVariable();
    private final LiveSet<String> codesets = new LiveSet(new HashSet());
    public final LiveExpression<String[]> validCodesetNames;
    private final LiveVariable<BuildType> buildType;
    private final LiveExpression<ValidationResult> guideValidator;
    private final LiveExpression<ValidationResult> codesetValidator;
    private final LiveExpression<ValidationResult> buildTypeValidator;
    public final LiveExpression<Boolean> isDownloaded;
    private final LiveExpression<Void> autoSelectBuildType;
    public final LiveExpression<ValidationResult> downloadStatus;
    public final LiveExpression<String> description;
    public final LiveExpression<URL> homePage;
    private final LiveVariable<Boolean> enableOpenHomePage;

    public GSImportWizardModel() {
        this.codesets.addAll((Object[])GettingStartedGuide.defaultCodesetNames());
        this.validCodesetNames = new LiveExpression<String[]>(null){

            protected String[] compute() {
                try {
                    List<CodeSet> validSets;
                    GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                    if (g != null && (validSets = g.getCodeSets()) != null) {
                        String[] names = new String[validSets.size()];
                        int i = 0;
                        while (i < names.length) {
                            names[i] = validSets.get(i).getName();
                            ++i;
                        }
                        return names;
                    }
                }
                catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                    GSImportWizardModel.this.scheduleDownloadJob();
                }
                catch (Throwable e) {
                    WizardPlugin.log(e);
                }
                return GettingStartedGuide.defaultCodesetNames();
            }
        };
        this.buildType = new LiveVariable((Object)BuildType.DEFAULT);
        this.guideValidator = Validator.notNull(this.guide, (String)"No GS content selected");
        this.codesetValidator = new CodeSetValidator(this.guide, this.codesets, this.validCodesetNames);
        this.buildTypeValidator = new Validator(){

            protected ValidationResult compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                BuildType bt = (BuildType)((Object)GSImportWizardModel.this.buildType.getValue());
                return GSImportWizardModel.this.validateBuildType(g, bt);
            }
        };
        this.isDownloaded = new LiveExpression<Boolean>(Boolean.valueOf(false)){

            protected Boolean compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null && !g.isDownloaded()) {
                    return false;
                }
                return true;
            }
        };
        this.autoSelectBuildType = new LiveExpression<Void>(){

            protected Void compute() {
                BuildType bt;
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null && g.isDownloaded() && !GSImportWizardModel.this.validateBuildType(g, bt = (BuildType)((Object)GSImportWizardModel.this.buildType.getValue())).isOk()) {
                    BuildType[] buildTypeArray = BuildType.values();
                    int n = buildTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BuildType other = buildTypeArray[n2];
                        if (other != bt && GSImportWizardModel.this.validateBuildType(g, other).isOk()) {
                            GSImportWizardModel.this.buildType.setValue((Object)other);
                        }
                        ++n2;
                    }
                }
                return null;
            }
        }.dependsOn(this.isDownloaded).dependsOn(this.guide);
        this.downloadStatus = new Validator(){

            protected ValidationResult compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g == null) {
                    return ValidationResult.OK;
                }
                return ValidationResult.from((IStatus)g.getZip().getDownloadStatus());
            }
        };
        this.description = new LiveExpression<String>("<no description>"){

            protected String compute() {
                Object g = GSImportWizardModel.this.rawSelection.getValue();
                if (g != null && g instanceof Describable) {
                    return ((Describable)g).getDescription();
                }
                return "Select Getting Started Content to see its Description";
            }
        };
        this.homePage = new LiveExpression<URL>(null){

            protected URL compute() {
                GSContent g = (GSContent)GSImportWizardModel.this.guide.getValue();
                if (g != null) {
                    return g.getHomePage();
                }
                return null;
            }
        };
        this.enableOpenHomePage = new LiveVariable((Object)true);
        this.buildTypeValidator.dependsOn(this.guide);
        this.buildTypeValidator.dependsOn(this.isDownloaded);
        this.buildTypeValidator.dependsOn(this.buildType);
        this.buildTypeValidator.dependsOn(this.codesets);
        this.isDownloaded.dependsOn(this.guide);
        this.downloadStatus.dependsOn(this.guide);
        this.description.dependsOn(this.rawSelection);
        this.homePage.dependsOn(this.guide);
        this.validCodesetNames.dependsOn(this.guide);
        this.validCodesetNames.dependsOn(this.isDownloaded);
        this.codesetValidator.dependsOn(this.isDownloaded);
    }

    static final ValidationResult isDownloadingMessage(GSContent g) {
        return ValidationResult.info((String)(String.valueOf(g.getDisplayName()) + " is downloading..."));
    }

    private ValidationResult validateBuildType(GSContent g, BuildType bt) {
        try {
            if (g != null) {
                try {
                    if (bt == null) {
                        return ValidationResult.error((String)"No build type selected");
                    }
                    List codesetNames = this.codesets.getValues();
                    if (codesetNames != null) {
                        for (String csname : codesetNames) {
                            CodeSet cs = g.getCodeSet(csname);
                            if (cs == null) continue;
                            ValidationResult result = cs.validateBuildType(bt);
                            if (!result.isOk()) {
                                return result.withMessage("CodeSet '" + csname + "': " + result.msg);
                            }
                            ImportStrategy importStrategy = bt.getImportStrategy();
                            if (importStrategy.isSupported()) continue;
                            return ValidationResult.error((String)bt.getNotInstalledMessage());
                        }
                    }
                }
                catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                    this.scheduleDownloadJob();
                    return GSImportWizardModel.isDownloadingMessage(g);
                }
            }
            return ValidationResult.OK;
        }
        catch (Throwable e) {
            WizardPlugin.log(e);
            return ValidationResult.error((String)ExceptionUtil.getMessage((Throwable)e));
        }
    }

    public void performDownload(IProgressMonitor mon) {
        mon.beginTask("Downloading", 1);
        try {
            try {
                GSContent g = (GSContent)this.guide.getValue();
                if (g != null) {
                    g.getZip().getFile();
                }
            }
            catch (Exception e) {
                WizardPlugin.log(e);
                this.isDownloaded.refresh();
                this.downloadStatus.refresh();
                mon.done();
            }
        }
        finally {
            this.isDownloaded.refresh();
            this.downloadStatus.refresh();
            mon.done();
        }
    }

    private void scheduleDownloadJob() {
        Job job = new Job("Downloading guide content"){

            protected IStatus run(IProgressMonitor mon) {
                try {
                    GSImportWizardModel.this.performDownload(mon);
                }
                catch (Throwable e) {
                    return ExceptionUtil.status((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public boolean performFinish(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        GSContent g = (GSContent)this.guide.getValue();
        BuildType bt = (BuildType)((Object)this.buildType.getValue());
        Set codesetNames = (Set)this.codesets.getValue();
        mon.beginTask("Import guide content", codesetNames.size() + 1);
        try {
            for (String name : codesetNames) {
                CodeSet cs = g.getCodeSet(name);
                if (cs == null) {
                    mon.worked(1);
                    continue;
                }
                IRunnableWithProgress oper = bt.getImportStrategy().createOperation(ImportUtils.importConfig(g, cs));
                oper.run((IProgressMonitor)new SubProgressMonitor(mon, 1));
            }
            if (((Boolean)this.enableOpenHomePage.getValue()).booleanValue()) {
                this.openHomePage();
            }
            return true;
        }
        catch (UIThreadDownloadDisallowed e) {
            WizardPlugin.log(e);
            return false;
        }
        finally {
            mon.done();
        }
    }

    public void openHomePage() {
        URL url = (URL)this.homePage.getValue();
        if (url != null) {
            UiUtil.openUrl((String)url.toString());
        }
    }

    public SelectionModel<BuildType> getBuildTypeModel() {
        return new SelectionModel(this.buildType, this.buildTypeValidator);
    }

    public SelectionModel<GSContent> getGSContentSelectionModel() {
        return new SelectionModel(this.guide, this.guideValidator);
    }

    public MultiSelectionModel<String> getCodeSetModel() {
        return new MultiSelectionModel<String>(this.codesets, this.codesetValidator);
    }

    public LiveExpression<Boolean> isDownloaded() {
        return this.isDownloaded;
    }

    public LiveVariable<Boolean> getEnableOpenHomePage() {
        return this.enableOpenHomePage;
    }

    public void setItem(GSContent guide) {
        this.guide.setValue((Object)guide);
    }

    public LiveVariable<Object> getRawSelection() {
        return this.rawSelection;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void setContentManager(ContentManager contentManager) {
        this.contentManager = contentManager;
    }

    public class CodeSetValidator
    extends LiveExpression<ValidationResult> {
        private final LiveVariable<GSContent> codesetProvider;
        private final LiveSet<String> selectedNames;
        private final LiveExpression<String[]> validCodesetNames;

        public CodeSetValidator(LiveVariable<GSContent> guide, LiveSet<String> codesets, LiveExpression<String[]> validCodeSetNames) {
            this.codesetProvider = guide;
            this.selectedNames = codesets;
            this.validCodesetNames = validCodeSetNames;
            this.dependsOn((LiveExpression)guide);
            this.dependsOn((LiveExpression)codesets);
            this.dependsOn(validCodeSetNames);
        }

        protected ValidationResult compute() {
            block7: {
                try {
                    GSContent g = (GSContent)this.codesetProvider.getValue();
                    if (g == null) break block7;
                    boolean codesetSelected = false;
                    try {
                        String[] validNames;
                        Set names = (Set)this.selectedNames.getValue();
                        if (names != null && !names.isEmpty()) {
                            for (String name : names) {
                                CodeSet cs = g.getCodeSet(name);
                                if (cs == null) continue;
                                codesetSelected = true;
                                ImportConfiguration conf = ImportUtils.importConfig(g, cs);
                                ValidationResult valid = ImportUtils.validateImportConfiguration(conf);
                                if (valid.isOk()) continue;
                                return valid;
                            }
                        }
                        if (!codesetSelected && (validNames = (String[])this.validCodesetNames.getValue()) != null && validNames.length > 0) {
                            return ValidationResult.error((String)"At least one codeset should be selected");
                        }
                    }
                    catch (UIThreadDownloadDisallowed uIThreadDownloadDisallowed) {
                        GSImportWizardModel.this.scheduleDownloadJob();
                        return GSImportWizardModel.isDownloadingMessage(g);
                    }
                }
                catch (Throwable e) {
                    WizardPlugin.log(e);
                    return ValidationResult.error((String)ExceptionUtil.getMessage((Throwable)e));
                }
            }
            return ValidationResult.OK;
        }
    }
}

