/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.AGSContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.Repo;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;

public abstract class GithubRepoContent
extends AGSContent {
    private DownloadableItem zip;

    protected GithubRepoContent(DownloadManager dl) {
        super(dl);
    }

    @Override
    public URL getHomePage() {
        try {
            return new URL(this.getRepo().getHtmlUrl());
        }
        catch (MalformedURLException e) {
            WizardPlugin.log(e);
            return null;
        }
    }

    public abstract Repo getRepo();

    @Override
    public DownloadableItem getZip() {
        if (this.zip == null) {
            String repoUrl = this.getRepo().getHtmlUrl();
            try {
                DownloadableItem item = new DownloadableItem(new URL(String.valueOf(repoUrl) + "/archive/master.zip"), this.downloader);
                item.setFileName(this.getRepo().getName());
                this.zip = item;
            }
            catch (MalformedURLException e) {
                WizardPlugin.log(e);
                return null;
            }
        }
        return this.zip;
    }

    @Override
    public String getName() {
        return this.getRepo().getName();
    }

    public IPath getRootPath() {
        return new Path(String.valueOf(this.getRepo().getName()) + "-master");
    }

    @Override
    public String getDescription() {
        return this.getRepo().getDescription();
    }
}

