/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.json.IdAble;

public class InitializrServiceSpec {
    private JSONObject data;

    public InitializrServiceSpec(JSONObject jsonObject) {
        this.data = jsonObject;
    }

    public static InitializrServiceSpec parseFrom(InputStream input) throws Exception {
        return new InitializrServiceSpec(new JSONObject(new JSONTokener((Reader)new InputStreamReader(input, "utf8"))));
    }

    public Map<String, String> getTextInputs() throws JSONException {
        HashMap<String, String> defaults = new HashMap<String, String>();
        Iterator props = this.data.keys();
        while (props.hasNext()) {
            String key = (String)props.next();
            JSONObject obj = this.data.getJSONObject(key);
            String type = obj.optString("type");
            if (!"text".equals(type)) continue;
            defaults.put(key, obj.optString("default", ""));
        }
        return defaults;
    }

    public Type[] getTypeOptions(String groupName) {
        try {
            JSONObject obj = this.data.optJSONObject(groupName);
            if (obj != null && "action".equals(obj.optString("type"))) {
                String defaultValue = obj.optString("default", "");
                JSONArray arr = obj.getJSONArray("values");
                Type[] options = new Type[arr.length()];
                int i = 0;
                while (i < options.length) {
                    JSONObject option = arr.getJSONObject(i);
                    options[i] = new Type();
                    String id = option.getString("id");
                    String name = option.getString("name");
                    String action = option.getString("action");
                    options[i].setId(id);
                    options[i].setName(name);
                    options[i].setAction(action);
                    options[i].setDefault(id.equals(defaultValue));
                    ++i;
                }
                return options;
            }
        }
        catch (JSONException jSONException) {}
        return new Type[0];
    }

    public Option[] getSingleSelectOptions(String groupName) {
        try {
            JSONObject obj = this.data.optJSONObject(groupName);
            if (obj != null && "single-select".equals(obj.optString("type"))) {
                String defaultValue = obj.optString("default", "");
                JSONArray arr = obj.getJSONArray("values");
                Option[] options = new Option[arr.length()];
                int i = 0;
                while (i < options.length) {
                    JSONObject option = arr.getJSONObject(i);
                    options[i] = new Option();
                    String id = option.getString("id");
                    String name = option.getString("name");
                    options[i].setId(id);
                    options[i].setName(name);
                    options[i].setDefault(id.equals(defaultValue));
                    ++i;
                }
                return options;
            }
        }
        catch (JSONException jSONException) {}
        return new Option[0];
    }

    public DependencyGroup[] getDependencies() {
        return this.getHierarchicalMultiSelect("dependencies");
    }

    private DependencyGroup[] getHierarchicalMultiSelect(String prop) {
        try {
            JSONObject obj = this.data.optJSONObject(prop);
            if (obj != null && "hierarchical-multi-select".equals(obj.optString("type"))) {
                JSONArray arr = obj.getJSONArray("values");
                DependencyGroup[] groups = new DependencyGroup[arr.length()];
                int i = 0;
                while (i < groups.length) {
                    JSONObject group = arr.getJSONObject(i);
                    groups[i] = new DependencyGroup();
                    String name = group.getString("name");
                    JSONArray values = group.getJSONArray("values");
                    groups[i].setName(name);
                    groups[i].setContent(Dependency.from(values));
                    ++i;
                }
                return groups;
            }
        }
        catch (JSONException jSONException) {}
        return new DependencyGroup[0];
    }

    public static class Dependency
    extends Nameable
    implements IdAble {
        private String id;
        private String description;
        private String versionRange;

        @Override
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public static Dependency[] from(JSONArray values) throws JSONException {
            Dependency[] deps = new Dependency[values.length()];
            int i = 0;
            while (i < deps.length) {
                JSONObject obj = values.getJSONObject(i);
                deps[i] = new Dependency();
                deps[i].setId(obj.getString("id"));
                deps[i].setName(obj.optString("name"));
                deps[i].setDescription(obj.optString("description"));
                deps[i].setVersionRange(obj.optString("versionRange"));
                ++i;
            }
            return deps;
        }

        public void setVersionRange(String range) {
            this.versionRange = range;
        }

        public String getVersionRange() {
            return this.versionRange;
        }
    }

    public static class DependencyGroup
    extends Nameable {
        private Dependency[] content;

        public Dependency[] getContent() {
            return this.content;
        }

        public void setContent(Dependency[] content) {
            this.content = content;
        }
    }

    public static abstract class Nameable {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Option
    extends Nameable {
        private String id;
        private boolean isDefault;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }
    }

    public static class Type
    extends Option {
        private String action;

        public void setAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }
}

