/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution2;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;

public abstract class BeanAttributeQuickFixProposal
implements ICompletionProposal,
IMarkerResolution2 {
    protected int offset;
    protected int length;
    private final boolean missingEndQuote;

    public BeanAttributeQuickFixProposal(int offset, int length, boolean missingEndQuote) {
        this.offset = offset;
        this.length = length;
        this.missingEndQuote = missingEndQuote;
    }

    public void apply(IDocument document) {
        try {
            if (this.missingEndQuote) {
                document.replace(this.offset + this.length, 0, "\"");
            }
            this.applyQuickFix(document);
        }
        catch (BadLocationException badLocationException) {}
    }

    public abstract void applyQuickFix(IDocument var1);

    public boolean equals(Object obj) {
        if (obj instanceof BeanAttributeQuickFixProposal) {
            BeanAttributeQuickFixProposal otherProposal = (BeanAttributeQuickFixProposal)obj;
            return otherProposal.offset == this.offset && otherProposal.length == this.length && otherProposal.getDisplayString().equals(this.getDisplayString());
        }
        return super.equals(obj);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public int hashCode() {
        return (String.valueOf(this.getDisplayString()) + this.offset + this.length).hashCode();
    }

    public void run(IMarker marker) {
        IDocument document = QuickfixUtils.getDocument(marker);
        if (document != null) {
            this.applyQuickFix(document);
        }
    }
}

