/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.springframework.ide.eclipse.quickfix.jdt.processors.JdtQuickfixUtils;
import org.springframework.ide.eclipse.quickfix.jdt.processors.RequestMappingDialog;

public class AddRequestMappingCompletionProposal
extends JavaTypeCompletionProposal {
    private static final String REQUEST_MAPPING_IMPORT = "org.springframework.web.bind.annotation.RequestMapping";
    private static final String REQUEST_METHOD_IMPORT = "org.springframework.web.bind.annotation.RequestMethod";
    private final ICompilationUnit cu;
    private final BodyDeclaration decl;

    public AddRequestMappingCompletionProposal(String typeName, BodyDeclaration decl, ICompilationUnit cu, int start, int length, int relevance) {
        super("", cu, start, length, null, AddRequestMappingCompletionProposal.getDisplayName(typeName), relevance);
        this.decl = decl;
        this.cu = cu;
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.applyChange(document, offset);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.applyChange(viewer.getDocument(), offset);
    }

    private void applyChange(IDocument document, int offset) {
        try {
            if (this.decl instanceof MethodDeclaration) {
                this.applyChangeForMethod(document, offset);
            } else if (this.decl instanceof TypeDeclaration) {
                this.applyChangeForType(document, offset);
            }
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void applyChangeForMethod(IDocument document, int offset) throws MalformedTreeException, JavaModelException, IllegalArgumentException, BadLocationException {
        MultiTextEdit edit = new MultiTextEdit();
        String methodTypeString = null;
        RequestMappingDialog dialog = new RequestMappingDialog(Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            RequestMappingDialog.Method methodType;
            TextEdit importEdit = JdtQuickfixUtils.getTextEditForImport(this.cu, REQUEST_MAPPING_IMPORT);
            if (importEdit != null) {
                edit.addChild(importEdit);
            }
            if ((methodType = dialog.getMethodType()) == RequestMappingDialog.Method.GET) {
                methodTypeString = "GET";
            } else if (methodType == RequestMappingDialog.Method.POST) {
                methodTypeString = "POST";
            }
            ASTRewrite astRewrite = ASTRewrite.create((AST)this.decl.getAST());
            NormalAnnotation annotation = astRewrite.getAST().newNormalAnnotation();
            annotation.setTypeName((Name)astRewrite.getAST().newSimpleName("RequestMapping"));
            if (methodTypeString != null) {
                importEdit = JdtQuickfixUtils.getTextEditForImport(this.cu, REQUEST_METHOD_IMPORT);
                if (importEdit != null) {
                    edit.addChild(importEdit);
                }
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
                AST annotationAST = annotation.getAST();
                MemberValuePair pair = annotationAST.newMemberValuePair();
                pair.setName(annotationAST.newSimpleName("method"));
                QualifiedName valueName = annotationAST.newQualifiedName((Name)annotationAST.newSimpleName("RequestMethod"), annotationAST.newSimpleName(methodTypeString));
                pair.setValue((Expression)valueName);
                listRewrite.insertFirst((ASTNode)pair, null);
            }
            astRewrite.getListRewrite((ASTNode)this.decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
            edit.addChild(astRewrite.rewriteAST());
            int oldLength = document.getLength();
            edit.apply(document);
            int diff = document.getLength() - oldLength;
            this.setCursorPosition(diff + offset);
        }
    }

    private void applyChangeForType(IDocument document, int offset) throws MalformedTreeException, JavaModelException, IllegalArgumentException, BadLocationException {
        MultiTextEdit edit = new MultiTextEdit();
        TextEdit importEdit = JdtQuickfixUtils.getTextEditForImport(this.cu, REQUEST_MAPPING_IMPORT);
        if (importEdit != null) {
            edit.addChild(importEdit);
        }
        ASTRewrite astRewrite = ASTRewrite.create((AST)this.decl.getAST());
        NormalAnnotation annotation = astRewrite.getAST().newNormalAnnotation();
        annotation.setTypeName((Name)astRewrite.getAST().newSimpleName("RequestMapping"));
        astRewrite.getListRewrite((ASTNode)this.decl, TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
        ITrackedNodePosition tracker = astRewrite.track((ASTNode)annotation.getTypeName());
        edit.addChild(astRewrite.rewriteAST());
        edit.apply(document);
        this.setReplacementOffset(tracker.getStartPosition() + annotation.getTypeName().getFullyQualifiedName().length() + 1);
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        this.applyChange(document, offset);
        return true;
    }

    private static StyledString getDisplayName(String typeName) {
        StyledString buf = new StyledString();
        buf.append("Add @RequestMapping annotation for '");
        buf.append(typeName);
        buf.append("'");
        return buf;
    }
}

