/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class RequestMappingRenameParticipant
extends RenameParticipant {
    private IFile file;
    private String oldName;
    private StringLiteral pathVariableLiteral;
    private PathVariableSourceRange methodPathVariableSourceRange;
    private PathVariableSourceRange typePathVariableSourceRange;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    private void getPositions(TextEdit edit, List<Integer> positions) {
        if (edit instanceof MultiTextEdit) {
            TextEdit[] textEditArray = ((MultiTextEdit)edit).getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                this.getPositions(child, positions);
                ++n2;
            }
        } else {
            positions.add(edit.getOffset());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        TextChange textChange;
        RenameArguments arguments = this.getArguments();
        String newName = arguments.getNewName();
        MultiTextEdit multiEdit = new MultiTextEdit();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.addAll(this.typePathVariableSourceRange.getOffsets());
        offsets.addAll(this.methodPathVariableSourceRange.getOffsets());
        if (this.pathVariableLiteral != null) {
            offsets.add(this.pathVariableLiteral.getStartPosition() + 1);
        }
        ArrayList<Integer> refactoredPositions = new ArrayList<Integer>();
        ProcessorBasedRefactoring refactoring = this.getProcessor().getRefactoring();
        if (refactoring != null && (textChange = refactoring.getTextChange((Object)this.file)) != null) {
            TextEdit edit = textChange.getEdit();
            this.getPositions(edit, refactoredPositions);
        }
        int changeCount = 0;
        int newLength = newName.length();
        int oldLength = this.oldName.length();
        int diff = newLength - oldLength;
        for (Integer offset : offsets) {
            ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
            Iterator iterator = refactoredPositions.iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                if (position >= offset) continue;
                ++changeCount;
                toBeRemoved.add(position);
            }
            refactoredPositions.removeAll(toBeRemoved);
            multiEdit.addChild((TextEdit)new ReplaceEdit(offset + changeCount * diff, oldLength, newName));
        }
        if (multiEdit.getChildrenSize() > 0) {
            TextFileChange change = new TextFileChange("", this.file);
            change.setEdit((TextEdit)multiEdit);
            return change;
        }
        return null;
    }

    private ICompilationUnit getCompilationUnit(IJavaElement element) {
        if (element == null || element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return this.getCompilationUnit(element.getParent());
    }

    public String getName() {
        return "Rename path variable referenced in @Controller class";
    }

    private void addPathVariableSourceRanges(BodyDeclaration decl, String pathVariable, PathVariableSourceRange sourceRange) throws JavaModelException {
        if (decl == null) {
            return;
        }
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("RequestMapping", (ASTNode)decl);
        for (Annotation annotation : annotations) {
            Expression value = null;
            if (annotation instanceof SingleMemberAnnotation) {
                value = ((SingleMemberAnnotation)annotation).getValue();
            } else if (annotation instanceof NormalAnnotation) {
                List pairs = ((NormalAnnotation)annotation).values();
                for (MemberValuePair pair : pairs) {
                    if (!"value".equals(pair.getName().getFullyQualifiedName())) continue;
                    value = pair.getValue();
                    break;
                }
            }
            if (!(value instanceof StringLiteral)) continue;
            String uri = ((StringLiteral)value).getLiteralValue();
            int offset = value.getStartPosition() + 1;
            while (uri != null && uri.length() > 0) {
                int index = uri.indexOf("{" + pathVariable + "}");
                if (index > 0) {
                    int pathVariableLength = pathVariable.length();
                    sourceRange.addOffset(offset + index + 1);
                    offset += index + pathVariableLength + 2;
                    uri = uri.substring(index + pathVariableLength + 2);
                    continue;
                }
                uri = null;
            }
        }
    }

    protected boolean initialize(Object element) {
        boolean hasPathVariable = false;
        if (element instanceof ILocalVariable) {
            ILocalVariable variable = (ILocalVariable)element;
            ICompilationUnit compilationUnit = this.getCompilationUnit((IJavaElement)variable);
            this.file = (IFile)compilationUnit.getResource();
            try {
                ISourceRange sourceRange = variable.getSourceRange();
                AssistContext assistContext = new AssistContext(compilationUnit, null, sourceRange.getOffset(), sourceRange.getLength());
                ASTNode node = assistContext.getCoveringNode();
                if (node instanceof SingleVariableDeclaration) {
                    String varName;
                    SingleVariableDeclaration varDecl = (SingleVariableDeclaration)node;
                    Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("PathVariable", (ASTNode)varDecl);
                    SimpleName varDeclName = varDecl.getName();
                    String pathVariableName = varName = varDeclName.getFullyQualifiedName();
                    StringLiteral pathVariableLiteral = null;
                    for (Annotation annotation : annotations) {
                        Expression value;
                        if (!(annotation instanceof SingleMemberAnnotation) || !((value = ((SingleMemberAnnotation)annotation).getValue()) instanceof StringLiteral)) continue;
                        pathVariableLiteral = (StringLiteral)value;
                        pathVariableName = pathVariableLiteral.getLiteralValue();
                        break;
                    }
                    if (varName.equals(pathVariableName)) {
                        hasPathVariable = true;
                        this.oldName = varName;
                        this.pathVariableLiteral = pathVariableLiteral;
                        MethodDeclaration methodDecl = (MethodDeclaration)ASTResolving.findAncestor((ASTNode)varDecl, (int)31);
                        this.methodPathVariableSourceRange = new PathVariableSourceRange();
                        this.addPathVariableSourceRanges((BodyDeclaration)methodDecl, pathVariableName, this.methodPathVariableSourceRange);
                        TypeDeclaration typeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)varDecl, (int)55);
                        this.typePathVariableSourceRange = new PathVariableSourceRange();
                        this.addPathVariableSourceRanges((BodyDeclaration)typeDecl, pathVariableName, this.typePathVariableSourceRange);
                    }
                }
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)e.getStatus());
            }
        }
        return hasPathVariable;
    }

    private class PathVariableSourceRange {
        private final List<Integer> offsets = new ArrayList<Integer>();

        public void addOffset(int offset) {
            this.offsets.add(offset);
        }

        public List<Integer> getOffsets() {
            return this.offsets;
        }
    }
}

