/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.services;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.services.ValidationService;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public abstract class AbstractDependenciesService
extends ValidationService {
    private boolean disposed = false;
    private IResourceChangeListener resourceChangeListener;

    protected void initValidationService() {
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource instanceof IWorkspaceRoot || resource instanceof IProject) {
                                return true;
                            }
                            if (resource instanceof IFile && "pom.xml".equals(resource.getName())) {
                                RefreshJob refreshJob = new RefreshJob();
                                refreshJob.setSystem(false);
                                refreshJob.setPriority(50);
                                refreshJob.schedule(200L);
                            }
                            return false;
                        }
                    });
                }
                catch (CoreException e) {
                    ArquillianUIActivator.log(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void dispose() {
        this.disposed = true;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    protected class RefreshJob
    extends Job {
        public RefreshJob() {
            super("Refreshing Arquillian editor...");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                if (!AbstractDependenciesService.this.disposed) {
                    AbstractDependenciesService.this.refresh();
                }
            }
            catch (Exception e) {
                ArquillianUIActivator.logWarning(e.getLocalizedMessage());
            }
            return Status.OK_STATUS;
        }
    }
}

