/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public final class OpenArquillianReferenceGuideHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                URL url = null;
                try {
                    url = new URL("https://docs.jboss.org/author/display/ARQ/Reference+Guide");
                }
                catch (MalformedURLException e) {
                    ArquillianUIActivator.log(e);
                    return;
                }
                OpenArquillianReferenceGuideHandler.openUrl(url, OpenArquillianReferenceGuideHandler.getShell(), false);
            }
        });
        return null;
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    private static void openUrl(URL url, Shell shell, boolean asExternal) {
        try {
            if (WebBrowserPreference.getBrowserChoice() == 1 || asExternal) {
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                support.getExternalBrowser().openURL(url);
            } else {
                IWebBrowser browser = null;
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.jboss.tools.arquillian.ui" + System.currentTimeMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", "Browser initialization failed");
            ArquillianUIActivator.getDefault().getLog().log((IStatus)status);
            MessageDialog.openError((Shell)shell, (String)"Open Location", (String)status.getMessage());
        }
    }
}

