/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.actions;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.jboss.tools.arquillian.editor.internal.model.Protocol;
import org.jboss.tools.arquillian.editor.internal.refactoring.AddDependenciesRefactoring;
import org.jboss.tools.arquillian.editor.internal.refactoring.AddDependenciesWizard;
import org.jboss.tools.arquillian.editor.internal.services.ProtocolDependenciesService;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.markers.RefactoringUtil;

public final class AddDependenciesActionContributor
extends PropertyEditorAssistContributor {
    public void contribute(PropertyEditorAssistContext context) {
        IProject project;
        Element element = context.getPart().getLocalModelElement();
        if (element instanceof Protocol && (project = (IProject)element.adapt(IProject.class)) != null && !ProtocolDependenciesService.testProtocolDependencies(project)) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">Add required dependencies...</a></p>");
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    List<Dependency> dependencies = ProtocolDependenciesService.getDependencies(project);
                    AddDependenciesRefactoring refactoring = new AddDependenciesRefactoring(project, dependencies);
                    AddDependenciesWizard wizard = new AddDependenciesWizard(refactoring);
                    RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    try {
                        operation.run(RefactoringUtil.getShell(), "");
                    }
                    catch (InterruptedException e) {
                        ArquillianUIActivator.log(e);
                    }
                }
            });
            PropertyEditorAssistSection section = context.getSection("problems");
            section.addContribution(contribution.create());
        }
    }
}

