/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public class ArquillianResourcesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.jboss.tools.arquillian.ui.ArquillianResourcesSelectionDialog";
    private IJavaProject javaProject;
    private List<IPath> allResources;
    private List<IPath> addedResources;

    public ArquillianResourcesSelectionDialog(Shell shell, IJavaProject javaProject, List<IPath> addedResources) {
        super(shell, true);
        this.javaProject = javaProject;
        this.setTitle("Resources selection");
        this.setMessage("Select resources:");
        this.setListLabelProvider(new ResourceLabelProvider());
        this.addedResources = addedResources;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ArquillianUIActivator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ArquillianUIActivator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.jboss.tools.arquillian.ui", 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourcesSearchItemsFilter();
    }

    protected Comparator getItemsComparator() {
        return new ResourcesSearchComparator();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        this.getResources();
        for (IPath resource : this.allResources) {
            contentProvider.add((Object)resource, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        if (item instanceof IPath) {
            return ((IPath)item).toString();
        }
        return null;
    }

    private void getResources() {
        this.allResources = new ArrayList<IPath>();
        if (this.javaProject != null && this.javaProject.isOpen()) {
            IPath testSourcePath = null;
            try {
                IClasspathEntry[] rawClasspath;
                IProject project = this.javaProject.getProject();
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
                    MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                    Build build = mavenProject.getBuild();
                    String testSourceDirectory = build.getTestSourceDirectory();
                    testSourcePath = Path.fromOSString((String)testSourceDirectory);
                    IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
                    testSourcePath = testSourcePath.makeRelativeTo(workspacePath).makeAbsolute();
                }
                IClasspathEntry[] iClasspathEntryArray = rawClasspath = this.javaProject.getRawClasspath();
                int n = rawClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot[] roots;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && (roots = this.javaProject.findPackageFragmentRoots(entry)) != null) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        int n3 = roots.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                            IPath path = root.getPath();
                            String projectLocation = project.getLocation().toOSString();
                            IPath projectPath = Path.fromOSString((String)projectLocation);
                            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
                            projectPath = projectPath.makeRelativeTo(workspacePath).makeAbsolute();
                            path = (projectPath = projectPath.removeLastSegments(1)).append(path);
                            if (path == null || !path.equals((Object)testSourcePath)) {
                                Object[] resources;
                                Object[] objectArray = resources = root.getNonJavaResources();
                                int n5 = resources.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Object resource = objectArray[n6];
                                    this.addResource(this.allResources, resource, root.getPath());
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e1) {
                ArquillianUIActivator.log(e1);
            }
        }
    }

    private void addResource(List<IPath> allResources, Object resource, IPath root) throws CoreException {
        if (resource instanceof IFile) {
            IPath resourcePath = ((IFile)resource).getFullPath().makeRelativeTo(root);
            if (!this.addedResources.contains(resourcePath)) {
                allResources.add(resourcePath);
            }
        } else if (resource instanceof IFolder) {
            IResource[] children;
            IFolder folder = (IFolder)resource;
            IResource[] iResourceArray = children = folder.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.addResource(allResources, child, root);
                ++n2;
            }
        }
    }

    private String convert(String text) {
        return text;
    }

    private class ResourceLabelProvider
    implements ILabelProvider {
        private ResourceLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IPath) {
                String text = ((IPath)element).toString();
                return ArquillianResourcesSelectionDialog.this.convert(text);
            }
            return null;
        }
    }

    private class ResourcesSearchComparator
    implements Comparator {
        private ResourcesSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = this.getName(o1);
            String s2 = this.getName(o2);
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        private String getName(Object element) {
            if (element instanceof IPath) {
                return ((IPath)element).toString();
            }
            return null;
        }
    }

    private class ResourcesSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private ResourcesSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)ArquillianResourcesSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String text = null;
            if (item instanceof IPath) {
                text = ((IPath)item).toString();
                text = ArquillianResourcesSelectionDialog.this.convert(text);
            }
            return this.matches(text);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

