/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.tools.arquillian.ui.internal.views.ArquillianView;

public class ExpandAllCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof ArquillianView) {
            ArquillianView view = (ArquillianView)activePart;
            CommonViewer viewer = view.getCommonViewer();
            ITreeSelection sel = viewer.getStructuredSelection();
            if (sel.isEmpty()) {
                return null;
            }
            for (Object object : sel) {
                this.expand(viewer, object);
            }
        }
        return null;
    }

    private void expand(CommonViewer viewer, Object object) {
        int level = -1;
        if (object instanceof ICompilationUnit) {
            level = 1;
        } else if (object instanceof IPackageFragment) {
            level = 2;
        } else if (object instanceof IPackageFragmentRoot) {
            level = 3;
        } else if (object instanceof IProject) {
            level = 4;
        }
        viewer.expandToLevel(object, level);
    }
}

