/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.commands;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;

public class ArquillianPropertyTester
extends PropertyTester {
    private static final String IS_ARQUILLIAN_JUNIT_TEST = "isArquillianJUnitTest";
    private static final String CAN_LAUNCH_AS_ARQUILLIAN_TEST = "canLaunchAsArquillianTest";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (CAN_LAUNCH_AS_ARQUILLIAN_TEST.equals(property)) {
            IJavaElement element = this.getElement(receiver);
            if (element == null) {
                return false;
            }
            return this.canLaunchAsArquillianJUnitTest(element);
        }
        if (IS_ARQUILLIAN_JUNIT_TEST.equals(property)) {
            if (receiver instanceof IType) {
                return ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)((IType)receiver), (boolean)false, (boolean)false, (boolean)false);
            }
            if (receiver instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)receiver;
                try {
                    IType[] types = icu.getAllTypes();
                    if (types.length > 0) {
                        return ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)types[0], (boolean)false, (boolean)false, (boolean)false);
                    }
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            if (receiver instanceof ITextSelection) {
                return ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)ArquillianUIUtil.getActiveType(), (boolean)false, (boolean)false, (boolean)false);
            }
        }
        return false;
    }

    private IJavaElement getElement(Object receiver) {
        IJavaElement element;
        if (!(receiver instanceof IAdaptable)) {
            return null;
        }
        if (receiver instanceof IJavaElement) {
            element = (IJavaElement)receiver;
        } else if (receiver instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)receiver));
        } else {
            element = (IJavaElement)((IAdaptable)receiver).getAdapter(IJavaElement.class);
            if (element == null) {
                IResource resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
                element = JavaCore.create((IResource)resource);
            }
        }
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canLaunchAsArquillianJUnitTest(IJavaElement element) {
        try {
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
                case 4: {
                    return ((IPackageFragment)element).hasChildren();
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    return ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)element, (boolean)true, (boolean)true, (boolean)false);
                }
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

