/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.services;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.editor.internal.model.Container;
import org.jboss.tools.arquillian.editor.internal.services.AbstractDependenciesService;
import org.jboss.tools.arquillian.editor.internal.utils.ArquillianEditorUtils;

public class ContainerProfilesService
extends AbstractDependenciesService {
    @Text(value="The {0} profile is not included into the project.")
    private static LocalizableText message;

    static {
        LocalizableText.init(ContainerProfilesService.class);
    }

    private static org.jboss.forge.arquillian.container.Container getContainer(Value<?> value) {
        if (value != null && value.element() instanceof Container) {
            String id = value.text();
            return ArquillianEditorUtils.getContainer(id);
        }
        return null;
    }

    protected Status compute() {
        String id;
        Value value = (Value)this.context(Value.class);
        IProject project = (IProject)value.element().adapt(IProject.class);
        org.jboss.forge.arquillian.container.Container c = ContainerProfilesService.getContainer(value);
        if (c != null && c.getId() != null && !c.getId().isEmpty() && !ContainerProfilesService.testProfile(project, id = c.getId())) {
            String msg = message.format(new Object[]{value.text(), id});
            return Status.createWarningStatus((String)msg);
        }
        return Status.createOkStatus();
    }

    public static boolean testProfile(IProject project, String id) {
        if (project != null && id != null && !id.isEmpty() && ArquillianEditorUtils.getContainer(id) != null) {
            List profiles = ArquillianUtility.getProfiles((IProject)project);
            return profiles != null && profiles.contains(id);
        }
        return true;
    }
}

