/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.ui.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.ui.style.AbstractAngularSemanticHighlighting;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractAngularExpressionSemanticHighlighting
extends AbstractAngularSemanticHighlighting {
    public String getEnabledPreferenceKey() {
        return "angularjs.ui.highlighting.expression.enabled";
    }

    @Override
    protected List<Position> consumes(IDOMNode node, IFile file, IStructuredDocumentRegion documentRegion) {
        NamedNodeMap attributes;
        if (!"XML_CONTENT".equals(documentRegion.getType()) && !"XML_TAG_NAME".equals(documentRegion.getType())) {
            return null;
        }
        String startSymbol = "{{";
        String endSymbol = "}}";
        if (file != null) {
            try {
                AngularProject angularProject = AngularProject.getAngularProject((IProject)file.getProject());
                startSymbol = angularProject.getStartSymbol();
                endSymbol = angularProject.getEndSymbol();
            }
            catch (CoreException coreException) {}
        }
        if ("XML_CONTENT".equals(documentRegion.getType())) {
            ArrayList<Position> positions = new ArrayList<Position>();
            String regionText = documentRegion.getText();
            int startOffset = documentRegion.getStartOffset();
            this.fillPositions(positions, startSymbol, endSymbol, regionText, startOffset);
            return positions;
        }
        if ("XML_TAG_NAME".equals(documentRegion.getType()) && (attributes = node.getAttributes()) != null) {
            ArrayList<Position> positions = new ArrayList<Position>();
            IDOMAttr attr = null;
            int i = 0;
            while (i < attributes.getLength()) {
                attr = (IDOMAttr)attributes.item(i);
                String regionText = attr.getValue();
                int startOffset = attr.getValueRegionStartOffset() + 1;
                this.fillPositions(positions, startSymbol, endSymbol, regionText, startOffset);
                ++i;
            }
            return positions;
        }
        return null;
    }

    private void fillPositions(List<Position> positions, String startExpression, String endExpression, String regionText, int startOffset) {
        int startIndex = regionText.indexOf(startExpression);
        int endIndex = -1;
        while (startIndex != -1) {
            endIndex = this.fillPosition(positions, startExpression, endExpression, regionText, startIndex, startOffset);
            if (endIndex == -1) break;
            startIndex = regionText.indexOf(startExpression, endIndex += endExpression.length());
        }
    }

    protected abstract int fillPosition(List<Position> var1, String var2, String var3, String var4, int var5, int var6);
}

