/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.dependencies;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.tools.arquillian.core.internal.dependencies.DependencyType;
import org.jboss.tools.arquillian.core.internal.dependencies.TypeLocation;

public class DependencyVisitor
extends ASTVisitor {
    private Set<DependencyType> types = new HashSet<DependencyType>();
    private String exclude;
    private CompilationUnit cu;
    private IJavaProject javaProject;
    private Set<String> excludeSet;

    public DependencyVisitor(CompilationUnit cu, String exclude, Set<String> excludeSet, IJavaProject javaProject) {
        this.exclude = exclude;
        this.cu = cu;
        this.javaProject = javaProject;
        this.excludeSet = excludeSet;
        if (this.excludeSet == null) {
            this.excludeSet = new HashSet<String>();
        }
    }

    public boolean visit(SimpleName node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding == null || binding.isPrimitive() || !binding.isFromSource()) {
            return true;
        }
        IJavaElement javaElement = binding.getJavaElement();
        if (javaElement == null || javaElement.getJavaProject() == null || !javaElement.getJavaProject().equals(this.javaProject)) {
            return true;
        }
        String[] stringArray = binding.getQualifiedName().split("[<>,\\s\\[\\]]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.equals(this.exclude) && !this.excludeSet.contains(name)) {
                int charEnd;
                int charStart;
                ASTNode parent = node.getParent();
                if (parent != null && parent.getNodeType() == 40) {
                    charStart = parent.getStartPosition();
                    charEnd = charStart + parent.getLength();
                } else {
                    charStart = node.getStartPosition();
                    charEnd = charStart + node.getLength();
                }
                int lineNumber = this.cu.getLineNumber(charStart);
                DependencyType type = new DependencyType(name);
                for (DependencyType t : this.types) {
                    if (!type.equals(t)) continue;
                    type = t;
                    break;
                }
                TypeLocation location = new TypeLocation(charStart, charEnd, lineNumber);
                type.getLocations().add(location);
                this.types.add(type);
            }
            ++n2;
        }
        return true;
    }

    public Set<DependencyType> getTypes() {
        return this.types;
    }

    public boolean visit(ImportDeclaration node) {
        return !node.isStatic();
    }
}

