/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;

public class ArquillianLaunchShortcut
extends JUnitLaunchShortcut {
    private static final String LAUNCH_GROUP_RUN = "org.eclipse.debug.ui.launchGroup.run";
    private static final String RUN_MODE = "run";
    private static final String LAUNCHING_OF_ARQILLIAN_J_UNIT_TESTS_FAILED = "Launching of Arqillian JUnit tests unexpectedly failed. Check log for details.";
    private static final String ARQUILLIAN_J_UNIT_LAUNCH = "Arquillian JUnit Launch";
    private static final String EMPTY_STRING = "";

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException {
        ILaunchConfigurationWorkingCopy config = super.createLaunchConfiguration(element);
        return config;
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.jdt.junit.launchconfig";
    }

    public void launch(IEditorPart editor, String mode) {
        ITypeRoot element = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (element != null) {
            IMethod selectedMethod = this.resolveSelectedMethodName(editor, element);
            if (selectedMethod != null) {
                this.launch(new Object[]{selectedMethod}, mode);
            } else {
                this.launch(new Object[]{element}, mode);
            }
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private IMethod resolveSelectedMethodName(IEditorPart editor, ITypeRoot element) {
        IJavaElement elementAtOffset;
        ITextSelection textSelection;
        block8: {
            ISelection selection;
            block7: {
                ISelectionProvider selectionProvider;
                block6: {
                    try {
                        selectionProvider = editor.getSite().getSelectionProvider();
                        if (selectionProvider != null) break block6;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                selection = selectionProvider.getSelection();
                if (selection instanceof ITextSelection) break block7;
                return null;
            }
            textSelection = (ITextSelection)selection;
            elementAtOffset = SelectionConverter.getElementAtOffset((ITypeRoot)element, (ITextSelection)textSelection);
            if (elementAtOffset instanceof IMethod) break block8;
            return null;
        }
        IMethod method = (IMethod)elementAtOffset;
        ISourceRange nameRange = method.getNameRange();
        if (nameRange.getOffset() <= textSelection.getOffset() && textSelection.getOffset() + textSelection.getLength() <= nameRange.getOffset() + nameRange.getLength()) {
            return method;
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)ArquillianLaunchShortcut.getShell(), (String)ARQUILLIAN_J_UNIT_LAUNCH, (String)"No Arquillian JUnit tests found");
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    private void launch(Object[] elements, String mode) {
        try {
            IType elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (!(selected instanceof IJavaElement) && selected instanceof IAdaptable) {
                    selected = ((IAdaptable)selected).getAdapter(IJavaElement.class);
                }
                if (selected instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)selected;
                    switch (element.getElementType()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            IJavaProject javaProject = element.getJavaProject();
                            if (!ArquillianSearchEngine.hasArquillianType((IJavaProject)javaProject)) break;
                            elementToLaunch = element;
                            break;
                        }
                        case 7: {
                            IType type = (IType)element;
                            if (ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)type, (boolean)true, (boolean)true)) {
                                elementToLaunch = type;
                            }
                        }
                        case 9: {
                            IJavaProject javaProject = element.getJavaProject();
                            if (!ArquillianSearchEngine.hasArquillianType((IJavaProject)javaProject)) break;
                            elementToLaunch = element;
                            break;
                        }
                        case 6: {
                            IType type = ((IClassFile)element).getType();
                            if (!ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)type, (boolean)true, (boolean)true, (boolean)false)) break;
                            elementToLaunch = type;
                            break;
                        }
                        case 5: {
                            elementToLaunch = this.findTypeToLaunch((ICompilationUnit)element, mode);
                        }
                    }
                }
            }
            if (elementToLaunch == null) {
                this.showNoTestsFoundDialog();
                return;
            }
            this.performLaunch((IJavaElement)elementToLaunch, mode);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)ArquillianLaunchShortcut.getShell(), (String)ARQUILLIAN_J_UNIT_LAUNCH, (String)LAUNCHING_OF_ARQILLIAN_J_UNIT_TESTS_FAILED);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)ArquillianLaunchShortcut.getShell(), (String)ARQUILLIAN_J_UNIT_LAUNCH, (String)LAUNCHING_OF_ARQILLIAN_J_UNIT_TESTS_FAILED);
        }
    }

    private IType findTypeToLaunch(ICompilationUnit cu, String mode) throws InterruptedException, InvocationTargetException {
        IType[] types = this.findTypesToLaunch(cu);
        ArrayList<IType> arquillianTypes = new ArrayList<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (ArquillianSearchEngine.isArquillianJUnitTest((IJavaElement)type, (boolean)true, (boolean)true)) {
                arquillianTypes.add(type);
            }
            ++n2;
        }
        types = arquillianTypes.toArray(new IType[0]);
        if (types.length == 0) {
            return null;
        }
        if (types.length > 1) {
            return this.chooseType(types, mode);
        }
        return types[0];
    }

    private IType[] findTypesToLaunch(ICompilationUnit cu) throws InterruptedException, InvocationTargetException {
        ITestKind testKind = TestKindRegistry.getContainerTestKind((IJavaElement)cu);
        return TestSearchEngine.findTests((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IJavaElement)cu, (ITestKind)testKind);
    }

    private void performLaunch(IJavaElement element, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(element);
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temparary, mode);
        if (config == null) {
            config = temparary.doSave();
        }
        if (this.preLaunchCheck(config, mode)) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected boolean preLaunchCheck(final ILaunchConfiguration configuration, final String mode) throws CoreException {
        final IStatus[] statuses = new IStatus[2];
        statuses[0] = ArquillianSearchEngine.validateDeployableContainer((IJavaProject)this.getJavaProject(configuration));
        if (!statuses[0].isOK()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        statuses[1] = ArquillianLaunchShortcut.this.fixArquillianLaunch(configuration, statuses[0], mode);
                    }
                    catch (CoreException e) {
                        ArquillianCoreActivator.log((Throwable)e);
                    }
                }
            });
            if (statuses[1].getSeverity() == 8) {
                return false;
            }
        }
        return true;
    }

    public IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        List<ILaunchConfiguration> candidateConfigs = this.findExistingLaunchConfigurations(temporary);
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(ArquillianLaunchShortcut.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private List<ILaunchConfiguration> findExistingLaunchConfigurations(ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (ArquillianLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        return candidateConfigs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            String[] stringArray = attributeToCompare;
            int n = attributeToCompare.length;
            int n2 = 0;
            while (true) {
                String val2;
                if (n2 >= n) {
                    return true;
                }
                String element = stringArray[n2];
                String val1 = config1.getAttribute(element, EMPTY_STRING);
                if (!val1.equals(val2 = config2.getAttribute(element, EMPTY_STRING))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IType chooseType(IType[] types, String mode) throws InterruptedException {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(ArquillianLaunchShortcut.getShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
        dialog.setElements((Object[])types);
        dialog.setTitle(JUnitMessages.JUnitLaunchShortcut_dialog_title2);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToDebug);
        } else {
            dialog.setMessage(JUnitMessages.JUnitLaunchShortcut_message_selectTestToRun);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    private IStatus fixArquillianLaunch(ILaunchConfiguration configuration, IStatus status, String mode) throws CoreException {
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals = status.getCode() == 0 ? new ClasspathFixProcessor.ClasspathFixProposal[]{new ArquillianLaunchFixProposal(configuration, "org.jboss.tools.arquillian.ui.action.addArquillianSupport", "Add Arquillian Support", true, 15)} : new ClasspathFixProcessor.ClasspathFixProposal[]{new ArquillianLaunchFixProposal(configuration, "org.jboss.tools.arquillian.ui.action.addArquillianProfiles", "Add Arquillian Profiles", true, 15), new ArquillianLaunchFixProposal(configuration, "org.eclipse.m2e.profiles.ui.commands.selectMavenProfileCommand", "Select Maven Profiles", true, 15)};
        LaunchFixSelectionDialog dialog = new LaunchFixSelectionDialog(ArquillianUtility.getShell(), configuration, ArquillianUtility.getJavaProject((ILaunchConfiguration)configuration), status.getMessage(), fixProposals, mode);
        if (dialog.open() == 1) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static void openLaunchConfiguration(ILaunchConfiguration configuration, String mode) {
        LaunchConfigurationManager lcManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        StructuredSelection selection = null;
        String category = "org.eclipse.debug.ui.launchGroup.debug";
        if (RUN_MODE.equals(mode)) {
            category = LAUNCH_GROUP_RUN;
        }
        if (configuration != null) {
            selection = new StructuredSelection((Object)configuration);
        }
        LaunchGroupExtension group = lcManager.getLaunchGroup(category);
        LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(ArquillianLaunchShortcut.getShell(), group);
        if (selection != null) {
            dialog.setInitialSelection((IStructuredSelection)selection);
            dialog.setOpenMode(3);
        } else {
            dialog.setOpenMode(2);
        }
        dialog.open();
    }

    private static class ArquillianLaunchFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private int relevance;
        private ILaunchConfiguration configuration;
        private String actionId;
        private boolean select;
        private String message;

        public ArquillianLaunchFixProposal(ILaunchConfiguration configuration, String actionId, String message, boolean select, int relevance) {
            this.configuration = configuration;
            this.relevance = relevance;
            this.actionId = actionId;
            this.select = select;
            this.message = message;
        }

        public String getAdditionalProposalInfo() {
            return this.message;
        }

        public Change createChange(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            ArquillianUtility.runAction((ILaunchConfiguration)this.configuration, (String)this.actionId, (boolean)this.select);
            return new NullChange();
        }

        public String getDisplayString() {
            return this.message;
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }

        public int getRelevance() {
            return this.relevance;
        }

        public String getActionId() {
            return this.actionId;
        }
    }

    private static class LaunchFixSelectionDialog
    extends MessageDialog
    implements SelectionListener,
    IDoubleClickListener {
        private final ClasspathFixProcessor.ClasspathFixProposal[] fixProposals;
        private final IJavaProject fProject;
        private TableViewer fFixSelectionTable;
        private Button fNoActionRadio;
        private Button fOpenBuildPathRadio;
        private Button fOpenLaunchConfiguration;
        private Button fPerformFix;
        private ArquillianLaunchFixProposal selectedFix;
        private IResourceChangeListener resourceChangeListener;
        private ILaunchConfiguration fConfiguration;
        private String mode;
        private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
        private static final String BUILD_PATH_BLOCK = "block_until_buildpath_applied";

        public LaunchFixSelectionDialog(Shell parent, ILaunchConfiguration configuration, IJavaProject project, String message, ClasspathFixProcessor.ClasspathFixProposal[] fixProposals, String mode) {
            super(parent, "Arquillian JUnit test", null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fConfiguration = configuration;
            this.fProject = project;
            this.fixProposals = fixProposals;
            this.selectedFix = null;
            this.mode = mode;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createCustomArea(Composite composite) {
            this.fNoActionRadio = new Button(composite, 16);
            this.fNoActionRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fNoActionRadio.setText("&Not now");
            this.fNoActionRadio.addSelectionListener((SelectionListener)this);
            this.fOpenBuildPathRadio = new Button(composite, 16);
            this.fOpenBuildPathRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenBuildPathRadio.setText("&Open the build path property page");
            this.fOpenBuildPathRadio.addSelectionListener((SelectionListener)this);
            this.fOpenLaunchConfiguration = new Button(composite, 16);
            this.fOpenLaunchConfiguration.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenLaunchConfiguration.setText("Open the &Launch Configuration");
            this.fOpenLaunchConfiguration.addSelectionListener((SelectionListener)this);
            if (this.fixProposals.length > 0) {
                this.fPerformFix = new Button(composite, 16);
                this.fPerformFix.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.fPerformFix.setText("&Perform the following action:");
                this.fPerformFix.addSelectionListener((SelectionListener)this);
                this.fFixSelectionTable = new TableViewer(composite, 2052);
                this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new LaunchFixLabelProvider());
                this.fFixSelectionTable.setComparator(new ViewerComparator());
                this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)this);
                this.fFixSelectionTable.setInput((Object)this.fixProposals);
                this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fixProposals[0]));
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(4);
                gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
                this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
                this.fNoActionRadio.setSelection(false);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fOpenLaunchConfiguration.setSelection(false);
                this.fPerformFix.setSelection(true);
            } else {
                this.fNoActionRadio.setSelection(true);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fOpenLaunchConfiguration.setSelection(false);
            }
            this.updateEnableStates();
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IStatus status = ArquillianSearchEngine.validateDeployableContainer((IJavaProject)fProject);
                    if (status.isOK()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.setReturnCode(0);
                                this.close();
                            }
                        });
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 16);
            return composite;
        }

        private void updateEnableStates() {
            if (this.fPerformFix != null) {
                this.fFixSelectionTable.getTable().setEnabled(this.fPerformFix.getSelection());
            }
        }

        public boolean close() {
            if (this.resourceChangeListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
                this.resourceChangeListener = null;
            }
            return super.close();
        }

        protected void buttonPressed(int buttonId) {
            ArquillianLaunchFixProposal fix;
            if (buttonId == 1) {
                super.buttonPressed(buttonId);
                return;
            }
            this.selectedFix = null;
            if (buttonId == 0) {
                IStructuredSelection selection;
                Object firstElement;
                if (this.fNoActionRadio.getSelection()) {
                    super.buttonPressed(buttonId);
                } else if (this.fOpenBuildPathRadio.getSelection()) {
                    String id = BUILD_PATH_PAGE_ID;
                    HashMap<String, Boolean> input = new HashMap<String, Boolean>();
                    input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                    if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
                        return;
                    }
                } else if (this.fOpenLaunchConfiguration.getSelection()) {
                    ArquillianLaunchShortcut.openLaunchConfiguration(this.fConfiguration, this.mode);
                    this.setReturnCode(1);
                    this.close();
                } else if (this.fFixSelectionTable != null && (firstElement = (selection = (IStructuredSelection)this.fFixSelectionTable.getSelection()).getFirstElement()) instanceof ArquillianLaunchFixProposal) {
                    this.selectedFix = (ArquillianLaunchFixProposal)((Object)firstElement);
                }
            }
            if ((fix = this.getSelectedClasspathFix()) != null) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    Change change = fix.createChange((IProgressMonitor)monitor);
                    new PerformChangeOperation(change).run((IProgressMonitor)monitor);
                    IStatus status = ArquillianSearchEngine.validateDeployableContainer((IJavaProject)this.fProject);
                    if (status.isOK()) {
                        super.okPressed();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.cancelPressed();
                }
                catch (Exception e) {
                    ArquillianCoreActivator.log((Throwable)e);
                }
            }
        }

        public ArquillianLaunchFixProposal getSelectedClasspathFix() {
            return this.selectedFix;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.okPressed();
        }

        static class LaunchFixLabelProvider
        extends LabelProvider {
            LaunchFixLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getDisplayString();
                }
                return null;
            }
        }
    }
}

