/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;
import org.jboss.tools.arquillian.ui.internal.wizards.CreateArquillianDeploymentMethodWizard;

public class GenerateArquillianDeploymentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICompilationUnit cu;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof ICompilationUnit) {
                this.createWizard((ICompilationUnit)object);
            }
            if (object instanceof IType) {
                this.createWizard(((IType)object).getCompilationUnit());
            }
        }
        if (selection instanceof ITextSelection && (cu = ArquillianUIUtil.getActiveCompilationUnit()) != null) {
            this.createWizard(cu);
        }
        return null;
    }

    private void createWizard(ICompilationUnit cu) {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new CreateArquillianDeploymentMethodWizard((IJavaElement)cu));
        dialog.open();
    }

    private Shell getShell() {
        if (Display.getCurrent() != null) {
            return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        }
        return null;
    }
}

