/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.util.xpl;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.security.Permission;
import java.util.PropertyPermission;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.util.xpl.ArquillianSecurityException;

public class ArquillianSecurityManager
extends SecurityManager {
    private SecurityManager fSecurityManager = null;
    private Thread fRestrictedThread = null;
    private IPreferenceStore arquillianPreferences = null;
    private static final PropertyPermission fgPropertyPermission = new PropertyPermission("*", "write");

    public ArquillianSecurityManager(SecurityManager securityManager, Thread restrictedThread) {
        this.fSecurityManager = securityManager;
        this.fRestrictedThread = restrictedThread;
        this.arquillianPreferences = ArquillianCoreActivator.getDefault().getPreferenceStore();
    }

    @Override
    public void checkExit(int status) {
        if (Thread.currentThread() == this.fRestrictedThread) {
            throw new ArquillianSecurityException("SecurityException: System.exit detected.");
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkExit(status);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccept(host, port);
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAccess(g);
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkConnect(host, port);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkCreateClassLoader();
        }
    }

    @Override
    public void checkDelete(String file) {
        if (Thread.currentThread() == this.fRestrictedThread) {
            throw new ArquillianSecurityException("SecurityException: Deleting a file is not allowed.");
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkDelete(file);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (!this.arquillianPreferences.getBoolean("allowOSCommand") && Thread.currentThread() == this.fRestrictedThread) {
            throw new ArquillianSecurityException("SecurityException: Exec denied.");
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (Thread.currentThread() == this.fRestrictedThread) {
            throw new ArquillianSecurityException("SecurityException: loadLibrary is not allowed.");
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkLink(lib);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkListen(port);
        }
    }

    public void checkMemberAccess(Class clazz, int which) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.fSecurityManager != null) {
            String host = maddr.getHostAddress();
            if (!host.startsWith("[") && host.indexOf(58) != -1) {
                host = "[" + host + "]";
            }
            this.checkPermission(new SocketPermission(host, "accept,connect"));
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!this.arquillianPreferences.getBoolean("allowSPCommand") && fgPropertyPermission.implies(perm) && this.fRestrictedThread == Thread.currentThread()) {
            throw new ArquillianSecurityException("SecurityException: Writing a system property is not allowed.");
        }
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPropertiesAccess();
        }
        super.checkPropertiesAccess();
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(file, context);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkRead(file);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkSecurityAccess(target);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkSetFactory();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkSystemClipboardAccess();
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.fSecurityManager != null) {
            return this.fSecurityManager.checkTopLevelWindow(window);
        }
        return super.checkTopLevelWindow(window);
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.checkWrite(file);
        }
    }

    public boolean getInCheck() {
        if (this.fSecurityManager != null) {
            return this.fSecurityManager.getInCheck();
        }
        return super.getInCheck();
    }

    @Override
    public Object getSecurityContext() {
        if (this.fSecurityManager != null) {
            return this.fSecurityManager.getSecurityContext();
        }
        return super.getSecurityContext();
    }

    @Override
    public ThreadGroup getThreadGroup() {
        if (this.fSecurityManager != null) {
            this.fSecurityManager.getThreadGroup();
        }
        return super.getThreadGroup();
    }
}

