/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;

public class ExceptionHandlerPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IExceptionHandler action;
    private IExceptionHandler actionClone;
    private Label beanLabel;
    private Text beanText;
    private Button okButton;
    private int LABEL_WIDTH = 70;
    private IDialogValidator validator;
    private Button browseBeanButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ExceptionHandlerPropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };

    public ExceptionHandlerPropertiesDialog(Shell parentShell, IWebflowModelElement parent, ExceptionHandler state) {
        super(parentShell);
        this.action = state;
        this.actionClone = state.cloneModelElement();
    }

    private String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.actionClone.setBean(this.trimString(this.beanText.getText()));
            ((ICloneableModelElement)this.action).applyCloneValues((IWebflowModelElement)this.actionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.beanText.setFocus();
        if (this.action != null && this.action.getBean() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.beanLabel = new Label(nameGroup, 0);
        this.beanLabel.setText("Bean");
        GridData gridData = new GridData(32);
        gridData.widthHint = this.LABEL_WIDTH;
        this.beanLabel.setLayoutData((Object)gridData);
        DecoratedField beanField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
        FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        beanField.addFieldDecoration(requiredFieldIndicator, 16512, true);
        this.beanText = (Text)beanField.getControl();
        GridData data = new GridData(768);
        beanField.getLayoutControl().setLayoutData((Object)data);
        if (this.action != null && this.action.getBean() != null) {
            this.beanText.setText(this.action.getBean());
        }
        this.beanText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExceptionHandlerPropertiesDialog.this.validator != null) {
                    ExceptionHandlerPropertiesDialog.this.validator.validateInput();
                }
            }
        });
        DialogUtils.attachContentAssist(this.beanText, WebflowUtils.getBeansFromEditorInput().toArray());
        this.browseBeanButton = new Button(nameGroup, 8);
        this.browseBeanButton.setText("...");
        this.browseBeanButton.setLayoutData((Object)new GridData(128));
        this.browseBeanButton.addSelectionListener(this.buttonListener);
        ExceptionHandlerPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.exception_handler_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the exception handler";
    }

    protected String getShellTitle() {
        return "Exception Handler";
    }

    protected String getTitle() {
        return "Exception Handler properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    @Override
    public void validateInput() {
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    private void handleButtonPressed(Button button) {
        ElementListSelectionDialog dialog;
        if (button.equals(this.browseBeanButton) && (dialog = DialogUtils.openBeanReferenceDialog(this.beanText.getText(), false)).open() == 0) {
            this.beanText.setText(((IBean)dialog.getFirstResult()).getElementName());
        }
    }
}

