/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

public class ActionOrphanChildCommand
extends Command {
    private IActionElement child;
    private IWebflowModelElement parent;
    private int index;

    public void execute() {
        IExitActions state;
        this.parent = (IWebflowModelElement)this.child.getElementParent();
        if (this.parent instanceof IEntryActions) {
            this.index = ((IEntryActions)this.parent).getEntryActions().indexOf(this.child);
            ((IEntryActions)this.parent).removeEntryAction(this.child);
        } else if (this.parent instanceof IExitActions) {
            this.index = ((IExitActions)this.parent).getExitActions().indexOf(this.child);
            ((IExitActions)this.parent).removeExitAction(this.child);
        } else if (this.parent instanceof IRenderActions) {
            this.index = ((IRenderActions)this.parent).getRenderActions().indexOf(this.child);
            ((IRenderActions)this.parent).removeRenderAction(this.child);
        } else if (this.parent instanceof IActionState) {
            this.index = ((IActionState)this.parent).getActions().indexOf(this.child);
            ((IActionState)this.parent).removeAction(this.child);
        }
        if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && this.parent instanceof IRenderActions) {
            IRenderActions state2 = (IRenderActions)this.parent;
            if (state2 != null && state2.getRenderActions().size() == 0) {
                ((IViewState)state2.getElementParent()).setRenderActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && this.parent instanceof IEntryActions) {
            IEntryActions state3 = (IEntryActions)this.parent;
            if (state3 != null && state3.getEntryActions().size() == 0) {
                ((IState)state3.getElementParent()).setEntryActions(null);
            }
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && this.parent instanceof IExitActions && (state = (IExitActions)this.parent) != null && state.getExitActions().size() == 0) {
            ((IState)state.getElementParent()).setExitActions(null);
        }
    }

    public void setChild(IActionElement child) {
        this.child = child;
    }

    public void undo() {
        if (this.child.getType() == IActionElement.ACTION_TYPE.ACTION && this.parent instanceof IActionState) {
            this.child.setElementParent(this.parent);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && this.parent instanceof IRenderActions) {
            IRenderActions state = (IRenderActions)this.parent;
            IViewState viewState = (IViewState)state.getElementParent();
            if (viewState.getRenderActions() == null) {
                viewState.setRenderActions(state);
            }
            this.child.setElementParent((IWebflowModelElement)state);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && this.parent instanceof IEntryActions) {
            IEntryActions state = (IEntryActions)this.parent;
            IState viewState = (IState)state.getElementParent();
            if (viewState.getEntryActions() == null) {
                viewState.setEntryActions(state);
            }
            this.child.setElementParent((IWebflowModelElement)state);
        } else if (this.child.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && this.parent instanceof IExitActions) {
            IExitActions state = (IExitActions)this.parent;
            IState viewState = (IState)state.getElementParent();
            if (viewState.getExitActions() == null) {
                viewState.setExitActions(state);
            }
            this.child.setElementParent((IWebflowModelElement)state);
        }
        if (this.parent instanceof IEntryActions) {
            ((IEntryActions)this.parent).addEntryAction(this.child, this.index);
        } else if (this.parent instanceof IExitActions) {
            ((IExitActions)this.parent).addExitAction(this.child, this.index);
        } else if (this.parent instanceof IRenderActions) {
            ((IRenderActions)this.parent).addRenderAction(this.child, this.index);
        } else if (this.parent instanceof IActionState) {
            ((IActionState)this.parent).addAction(this.child, this.index);
        }
    }
}

