/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.navigator.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class NonSpringElementsFilter
extends ViewerFilter {
    public static final String PROJECT_EXPLORER_EXTENSION_POINT = "org.springframework.ide.eclipse.ui.projectExplorer";
    private List<ViewerFilter> filters = new ArrayList<ViewerFilter>();

    public NonSpringElementsFilter() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PROJECT_EXPLORER_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    try {
                        Object filter = config.createExecutableExtension("class");
                        if (filter instanceof ViewerFilter) {
                            this.filters.add((ViewerFilter)filter);
                        }
                    }
                    catch (CoreException e) {
                        SpringUIPlugin.log(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = (IResource)SpringCoreUtils.getAdapter((Object)element, IResource.class);
        if (SpringCoreUtils.isSpringProject((IResource)resource)) {
            for (ViewerFilter filter : this.filters) {
                if (!filter.select(viewer, (Object)resource, element)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

