/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.plugin.inappbrowser;

import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.browsersim.browser.ExtendedCloseWindowListener;
import org.jboss.tools.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.browser.IBrowserFunction;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.browser.WebKitBrowserFactory;
import org.jboss.tools.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.browsersim.ui.model.Device;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;
import org.jboss.tools.cordovasim.CustomBrowserSim;
import org.jboss.tools.cordovasim.plugin.inappbrowser.ExecScriptFunction;

public class InAppBrowserLoader {
    public static boolean isInAppBrowserEvent(ExtendedWindowEvent openWindowEvent) {
        IBrowser parentBrowser = (IBrowser)openWindowEvent.widget;
        return Boolean.TRUE.equals(parentBrowser.evaluate("return !!window.needToOpenInAppBrowser"));
    }

    public static void processInAppBrowser(final IBrowser rippleToolSuiteBrowser, final CustomBrowserSim browserSim, ExtendedWindowEvent openWindowEvent) {
        String currentOs = PlatformUtil.getOs();
        rippleToolSuiteBrowser.execute("window.needToOpenInAppBrowser = false");
        final IBrowser browserSimBrowser = browserSim.getBrowser();
        final Composite browserSimParentComposite = browserSimBrowser.getParent();
        final StackLayout stackLayout = (StackLayout)browserSimParentComposite.getLayout();
        Device device = browserSim.getCurrentDevice();
        final IBrowser inAppBrowser = InAppBrowserLoader.createInAppBrowser(browserSimParentComposite, browserSimBrowser, device);
        browserSim.setInAppBrowser(inAppBrowser);
        if ("win32".equals(currentOs) && !(browserSimBrowser instanceof JavaFXBrowser)) {
            browserSimBrowser.setParent((Composite)inAppBrowser);
        }
        openWindowEvent.browser = inAppBrowser;
        stackLayout.topControl = (Control)inAppBrowser;
        browserSimParentComposite.layout();
        BrowserSimUtil.setCustomScrollbarStylesForWindows((IBrowser)inAppBrowser);
        inAppBrowser.addCloseWindowListener(new ExtendedCloseWindowListener(){

            public void close(ExtendedWindowEvent event) {
                browserSim.setInAppBrowser(null);
                stackLayout.topControl = (Control)browserSimBrowser;
                browserSimParentComposite.layout();
                inAppBrowser.dispose();
                rippleToolSuiteBrowser.execute("ripple('event').trigger('browser-close');");
                rippleToolSuiteBrowser.execute("ripple('emulatorBridge').window().ChildBrowser.onClose();");
            }
        });
        inAppBrowser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                rippleToolSuiteBrowser.execute("ripple('emulatorBridge').window().ChildBrowser.onLocationChange('" + event.location + "');");
            }

            public void changed(LocationEvent event) {
                if (event.top) {
                    rippleToolSuiteBrowser.execute("(function(){ripple('platform/cordova/3.0.0/bridge/inappbrowser').loadstart('" + event.location + "');})()");
                    rippleToolSuiteBrowser.execute("(function(){ripple('platform/cordova/3.0.0/bridge/inappbrowser').loadstop('" + event.location + "');})()");
                }
            }
        });
        if ("win32".equals(currentOs) && !(browserSimBrowser instanceof JavaFXBrowser)) {
            inAppBrowser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    browserSimBrowser.setParent(browserSimParentComposite);
                    stackLayout.topControl = (Control)browserSimBrowser;
                    browserSimParentComposite.layout();
                }
            });
        }
        browserSimBrowser.registerBrowserFunction("csInAppExecScript", (IBrowserFunction)new ExecScriptFunction(browserSimBrowser, inAppBrowser));
    }

    private static IBrowser createInAppBrowser(Composite browserSimParentComposite, IBrowser browserSimBrowser, Device device) {
        IBrowser inAppBrowser = new WebKitBrowserFactory().createBrowser(browserSimParentComposite, 0, browserSimBrowser instanceof JavaFXBrowser);
        inAppBrowser.setUserAgent(device.getUserAgent());
        return inAppBrowser;
    }
}

