/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class SpringConfigHeaderMessage {
    private final AbstractConfigEditor cEditor;
    private String message;
    private int messageType;

    public SpringConfigHeaderMessage(AbstractConfigEditor cEditor) {
        this.cEditor = cEditor;
    }

    public void setMessage(AbstractConfigFormPage page) {
        ScrolledForm form = page.getScrolledForm();
        if (form != null && !form.isDisposed()) {
            form.setMessage(this.message, this.messageType);
        }
    }

    public void updateMessage() {
        if (this.cEditor != null && this.cEditor.getResourceFile() != null && this.cEditor.getResourceFile().exists()) {
            try {
                IFile resource = this.cEditor.getResourceFile();
                IMarker[] markers = resource.findMarkers("org.springframework.ide.eclipse.core.problemmarker", true, 1);
                this.message = null;
                this.messageType = 0;
                if (markers.length > 0) {
                    int errorCount = 0;
                    int warningCount = 0;
                    int infoCount = 0;
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        Object attr = marker.getAttribute("severity");
                        if (attr instanceof Integer) {
                            Integer severity = (Integer)attr;
                            if (severity == 2) {
                                ++errorCount;
                            } else if (severity == 1) {
                                ++warningCount;
                            } else if (severity == 0) {
                                ++infoCount;
                            }
                        }
                        ++n2;
                    }
                    String errorMessage = "";
                    String warnMessage = "";
                    String infoMessage = "";
                    String errorSingular = Messages.getString("AbstractConfigFormPage.ERROR_SINGULAR");
                    String errorPlural = Messages.getString("AbstractConfigFormPage.ERROR_PLURAL");
                    String warningSingular = Messages.getString("AbstractConfigFormPage.WARNING_SINGULAR");
                    String warningPlural = Messages.getString("AbstractConfigFormPage.WARNING_PLURAL");
                    String infoSingular = Messages.getString("AbstractConfigFormPage.INFO_SINGULAR");
                    String infoPlural = Messages.getString("AbstractConfigFormPage.INFO_PLURAL");
                    if (infoCount > 0) {
                        this.messageType = 1;
                        infoMessage = infoCount > 1 ? String.valueOf(infoCount) + " " + infoPlural : String.valueOf(infoCount) + " " + infoSingular;
                    }
                    if (warningCount > 0) {
                        this.messageType = 2;
                        warnMessage = warningCount > 1 ? String.valueOf(warningCount) + " " + warningPlural : String.valueOf(warningCount) + " " + warningSingular;
                        if (infoCount > 0) {
                            warnMessage = String.valueOf(warnMessage) + ", ";
                        }
                    }
                    if (errorCount > 0) {
                        this.messageType = 3;
                        errorMessage = errorCount > 1 ? String.valueOf(errorCount) + " " + errorPlural : String.valueOf(errorCount) + " " + errorSingular;
                        if (warningCount > 0 || infoCount > 0) {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        }
                    }
                    this.message = String.valueOf(errorMessage) + warnMessage + infoMessage;
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("AbstractConfigFormPage.ERROR_UPDATING_PAGE_HEADER"), (Throwable)e));
            }
        }
    }
}

