/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddAutowireCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class AutowiredAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        int modifiers = fieldDecl.getModifiers();
        if (!Modifier.isStatic((int)modifiers) && !Modifier.isFinal((int)modifiers)) {
            return super.isQuickfixAvailable(fieldDecl, context);
        }
        return false;
    }

    private TypeDeclaration getEnclosingTypeDeclaration(ASTNode node) {
        if (node == null || node instanceof TypeDeclaration) {
            return (TypeDeclaration)node;
        }
        return this.getEnclosingTypeDeclaration(node.getParent());
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        List params;
        TypeDeclaration typeDecl;
        if (methodDecl.isConstructor() && (typeDecl = this.getEnclosingTypeDeclaration((ASTNode)methodDecl)) != null) {
            List decls = typeDecl.bodyDeclarations();
            for (BodyDeclaration decl : decls) {
                MethodDeclaration currentMethodDecl;
                if (!(decl instanceof MethodDeclaration) || !(currentMethodDecl = (MethodDeclaration)decl).isConstructor() || currentMethodDecl == methodDecl || !ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)currentMethodDecl)) continue;
                return false;
            }
        }
        Type returnType = methodDecl.getReturnType2();
        if ((methodDecl.isConstructor() || returnType != null && returnType.isPrimitiveType() && PrimitiveType.VOID.equals(((PrimitiveType)returnType).getPrimitiveTypeCode())) && (params = methodDecl.parameters()) != null && !params.isEmpty()) {
            return super.isQuickfixAvailable(methodDecl, context);
        }
        return false;
    }

    @Override
    public String getAnnotationName() {
        return "Autowired";
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForField(FieldDeclaration fieldDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssistsForDecl((BodyDeclaration)fieldDecl, name, cu);
    }

    private List<IJavaCompletionProposal> getAssistsForDecl(BodyDeclaration decl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddAutowireCompletionProposal(decl, cu, new AddAutowireCompletionProposal.Param[0]));
        proposals.add((IJavaCompletionProposal)new AddAutowireCompletionProposal(decl, cu, AddAutowireCompletionProposal.Param.REQUIRED));
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssistsForDecl((BodyDeclaration)methodDecl, name, cu);
    }
}

